/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.debug.agent;

import com.github.jlangch.venice.impl.debug.agent.Break;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class WaitableBreak {
    private final Break br;
    private final AtomicBoolean waiting = new AtomicBoolean(false);

    public WaitableBreak(Break br, boolean waiting) {
        if (br == null) {
            throw new IllegalArgumentException("A break must not be null");
        }
        this.br = br;
        this.waiting.set(waiting);
    }

    public Break getBreak() {
        return this.br;
    }

    public boolean isWaitingOnBreak() {
        return this.waiting.get();
    }

    public void stopWaitingOnBreak() {
        this.waiting.set(false);
    }

    public String toString() {
        return String.format("%s\n%s %b", this.br.toString(), StringUtil.padRight("Waiting:", Break.FORMAT_PAD_LEN), this.waiting.get());
    }

    public int hashCode() {
        return this.br.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof WaitableBreak && this.br.equals(((WaitableBreak)obj).br);
    }
}

