/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.debug.agent;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.debug.agent.Break;
import com.github.jlangch.venice.impl.debug.agent.IBreakListener;
import com.github.jlangch.venice.impl.debug.agent.IDebugAgent;
import com.github.jlangch.venice.impl.debug.agent.Step;
import com.github.jlangch.venice.impl.debug.agent.StepMode;
import com.github.jlangch.venice.impl.debug.agent.StepModeFormatter;
import com.github.jlangch.venice.impl.debug.agent.WaitableBreak;
import com.github.jlangch.venice.impl.debug.breakpoint.AncestorSelector;
import com.github.jlangch.venice.impl.debug.breakpoint.AncestorType;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFn;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.debug.breakpoint.Selector;
import com.github.jlangch.venice.impl.debug.util.SpecialFormVirtualFunction;
import com.github.jlangch.venice.impl.debug.util.StepValidity;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class DebugAgent
implements IDebugAgent {
    private static final long BREAK_LOOP_SLEEP_MILLIS = 500L;
    private static final ConcurrentHashMap<BreakpointFnRef, BreakpointFn> memorized = new ConcurrentHashMap();
    private final List<WaitableBreak> breaks = new CopyOnWriteArrayList<WaitableBreak>();
    private volatile Step step = new Step();
    private volatile boolean skipBreakpoints = false;
    private volatile IBreakListener breakListener = null;
    private final ConcurrentHashMap<BreakpointFnRef, BreakpointFn> breakpoints = new ConcurrentHashMap();

    public static void register(DebugAgent agent) {
        ThreadContext.setDebugAgent(agent);
    }

    public static void unregister() {
        ThreadContext.setDebugAgent(null);
    }

    public static DebugAgent current() {
        return ThreadContext.getDebugAgent();
    }

    public static boolean isAttached() {
        return ThreadContext.getDebugAgent() != null;
    }

    @Override
    public void detach() {
        this.clearAll();
    }

    @Override
    public List<BreakpointFn> getBreakpoints() {
        return this.breakpoints.values().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public void addBreakpoint(BreakpointFn breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("A breakpoint must not be null");
        }
        BreakpointFnRef ref = breakpoint.getBreakpointRef();
        BreakpointFn bp = this.breakpoints.get(ref);
        if (bp == null) {
            this.breakpoints.put(ref, breakpoint);
        } else {
            this.breakpoints.remove(ref);
            this.breakpoints.put(ref, bp.merge(breakpoint.getSelectors()));
        }
    }

    @Override
    public void addBreakpoints(List<BreakpointFn> breakpoints) {
        if (breakpoints != null) {
            breakpoints.forEach(b -> this.addBreakpoint((BreakpointFn)b));
        }
    }

    @Override
    public void removeBreakpoint(BreakpointFn breakpoint) {
        if (breakpoint != null) {
            this.breakpoints.remove(breakpoint.getBreakpointRef());
        }
    }

    @Override
    public void removeBreakpoints(List<BreakpointFn> breakpoints) {
        if (breakpoints != null) {
            breakpoints.forEach(b -> this.removeBreakpoint((BreakpointFn)b));
        }
    }

    @Override
    public void removeAllBreakpoints() {
        this.breakpoints.clear();
    }

    @Override
    public void skipBreakpoints(boolean skip) {
        this.skipBreakpoints = skip;
    }

    @Override
    public boolean isSkipBreakpoints() {
        return this.skipBreakpoints;
    }

    @Override
    public void storeBreakpoints() {
        memorized.putAll(this.breakpoints);
    }

    @Override
    public void restoreBreakpoints() {
        this.breakpoints.putAll(memorized);
    }

    @Override
    public boolean hasBreakpointFor(BreakpointFnRef bpRef) {
        switch (this.step.mode()) {
            case SteppingDisabled: {
                return !this.skipBreakpoints && this.breakpoints.containsKey(bpRef);
            }
            case StepToAny: 
            case StepToNextFunction: 
            case StepToNextNonSystemFunction: 
            case StepToNextFunctionCall: 
            case StepOverFunction: 
            case StepOverFunction_NextCall: 
            case StepToFunctionEntry: 
            case StepToFunctionExit: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addBreakListener(IBreakListener listener) {
        this.breakListener = listener;
    }

    public void onBreakSpecialForm(String specialForm, FunctionScope scope, VncVector params, VncList args, VncVal meta, Env env, CallStack callstack) {
        if (this.isStopOnFunction(specialForm, true, FunctionScope.FunctionEntry)) {
            this.handleBreak(new Break(new BreakpointFnRef(specialForm), new SpecialFormVirtualFunction(specialForm, params, meta), args, env, callstack, FunctionScope.FunctionEntry, Thread.currentThread().getName()));
        }
    }

    public void onBreakSpecialForm(String varBindingForm, FunctionScope scope, List<Var> vars, VncVal meta, Env env, CallStack callstack) {
        if (this.isStopOnFunction(varBindingForm, true, FunctionScope.FunctionEntry)) {
            Collections.sort(vars, Comparator.comparing(v -> v.getName()));
            this.handleBreak(new Break(new BreakpointFnRef(varBindingForm), new SpecialFormVirtualFunction(varBindingForm, vars, meta), VncList.ofColl(vars.stream().map(v -> v.getVal()).collect(Collectors.toList())), env, callstack, FunctionScope.FunctionEntry, Thread.currentThread().getName()));
        }
    }

    public void onBreakLoop(FunctionScope scope, RecursionPoint recursionPoint, Env env, CallStack callstack) {
        if (this.isStopOnFunction("loop", true, FunctionScope.FunctionEntry)) {
            List<VncSymbol> loopBindingNames = recursionPoint.getLoopBindingNames();
            VncVal meta = recursionPoint.getMeta();
            this.handleBreak(new Break(new BreakpointFnRef("loop"), new SpecialFormVirtualFunction("loop", VncVector.ofColl(loopBindingNames), meta), VncList.ofColl(loopBindingNames.stream().map(s -> env.findLocalVar((VncSymbol)s)).map(v -> v == null ? Constants.Nil : v.getVal()).collect(Collectors.toList())), env, callstack, FunctionScope.FunctionEntry, Thread.currentThread().getName()));
        }
    }

    public void onBreakFnCall(String fnName, VncFunction fn, VncList unevaluatedArgs, Env env, CallStack callstack) {
        if (this.isStopOnFunction(fnName, false, FunctionScope.FunctionCall)) {
            this.handleBreak(new Break(new BreakpointFnRef(fnName), fn, unevaluatedArgs, env, callstack, FunctionScope.FunctionCall, Thread.currentThread().getName()));
        }
    }

    public void onBreakFnEnter(String fnName, VncFunction fn, VncList evaluatedArgs, Env env, CallStack callstack) {
        if (this.isStopOnFunction(fnName, false, FunctionScope.FunctionEntry)) {
            this.handleBreak(new Break(new BreakpointFnRef(fnName), fn, evaluatedArgs, env, callstack, FunctionScope.FunctionEntry, Thread.currentThread().getName()));
        }
    }

    public void onBreakFnExit(String fnName, VncFunction fn, VncList evaluatedArgs, VncVal retVal, Env env, CallStack callstack) {
        if (this.isStopOnFunction(fnName, false, FunctionScope.FunctionExit)) {
            this.handleBreak(new Break(new BreakpointFnRef(fnName), fn, evaluatedArgs, retVal, null, env, callstack, FunctionScope.FunctionExit, Thread.currentThread().getName()));
        }
    }

    public void onBreakFnException(String fnName, VncFunction fn, VncList evaluatedArgs, Exception ex, Env env, CallStack callstack) {
        if (this.isStopOnFunction(fnName, false, FunctionScope.FunctionException)) {
            this.handleBreak(new Break(new BreakpointFnRef(fnName), fn, evaluatedArgs, null, ex, env, callstack, FunctionScope.FunctionException, Thread.currentThread().getName()));
        }
    }

    @Override
    public Break getActiveBreak() {
        this.cleanBreaks();
        WaitableBreak wbr = this.getActiveWaitableBreak();
        return wbr == null ? null : wbr.getBreak();
    }

    @Override
    public boolean hasActiveBreak() {
        return this.getActiveBreak() != null;
    }

    @Override
    public Break switchActiveBreak(int index) {
        try {
            int collIdx = index - 1;
            if (collIdx == 0) {
                return this.getActiveBreak();
            }
            if (collIdx > 0 && collIdx < this.breaks.size()) {
                WaitableBreak br = this.breaks.remove(collIdx);
                this.breaks.add(0, br);
                return this.getActiveBreak();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public List<Break> getAllBreaks() {
        return this.breaks.stream().filter(w -> w.isWaitingOnBreak()).map(w -> w.getBreak()).collect(Collectors.toList());
    }

    @Override
    public void clearBreaks() {
        this.step = this.step.clear();
        this.breaks.forEach(b -> b.stopWaitingOnBreak());
        this.breaks.clear();
    }

    @Override
    public void resume() {
        this.step = this.step.clear();
        WaitableBreak br = this.getActiveWaitableBreak();
        if (br != null) {
            br.stopWaitingOnBreak();
            this.breaks.remove(br);
        }
    }

    @Override
    public void resumeAll() {
        this.clearBreaks();
    }

    @Override
    public StepValidity step(StepMode mode) {
        StepValidity validity = this.isStepPossible(mode);
        if (!validity.isValid()) {
            return validity;
        }
        WaitableBreak wbr = this.getActiveWaitableBreak();
        if (wbr == null) {
            return StepValidity.invalid("Cannot step when there is no active break!");
        }
        Break br = wbr.getBreak();
        String brFnQualifiedName = br.getFn().getQualifiedName();
        switch (mode) {
            case StepToAny: {
                this.step = new Step(StepMode.StepToAny);
                break;
            }
            case StepToNextFunction: {
                this.step = new Step(StepMode.StepToNextFunction);
                break;
            }
            case StepToNextNonSystemFunction: {
                this.step = new Step(StepMode.StepToNextNonSystemFunction);
                break;
            }
            case StepToNextFunctionCall: {
                this.step = new Step(StepMode.StepToNextFunctionCall);
                break;
            }
            case StepOverFunction: {
                this.step = new Step(StepMode.StepOverFunction, brFnQualifiedName);
                break;
            }
            case StepToFunctionEntry: {
                if (br.isInScope(FunctionScope.FunctionCall)) {
                    this.step = new Step(StepMode.StepToFunctionEntry, brFnQualifiedName);
                    break;
                }
                this.step = this.step.clear();
                break;
            }
            case StepToFunctionExit: {
                if (br.isInScope(FunctionScope.FunctionCall, FunctionScope.FunctionEntry)) {
                    this.step = new Step(StepMode.StepToFunctionExit, brFnQualifiedName);
                    break;
                }
                this.step = this.step.clear();
                break;
            }
            default: {
                this.step = this.step.clear();
            }
        }
        wbr.stopWaitingOnBreak();
        return StepValidity.valid();
    }

    @Override
    public StepValidity isStepPossible(StepMode mode) {
        WaitableBreak wbr = this.getActiveWaitableBreak();
        if (mode == null) {
            throw new RuntimeException("A step mode must not be null");
        }
        if (wbr == null) {
            return StepValidity.invalid("Cannot step when there is no active break!");
        }
        Break br = wbr.getBreak();
        switch (mode) {
            case StepToAny: 
            case StepToNextFunction: 
            case StepToNextNonSystemFunction: 
            case StepToNextFunctionCall: 
            case StepOverFunction: {
                return StepValidity.valid();
            }
            case StepToFunctionEntry: {
                if (br.isInScope(FunctionScope.FunctionEntry)) {
                    return StepValidity.invalid("The current break is already at entry level!");
                }
                return br.isInScope(FunctionScope.FunctionCall) ? StepValidity.valid() : StepValidity.invalid("Stepping to the entry level of the current function is only possible if the current function is in a break at call level!");
            }
            case StepToFunctionExit: {
                if (br.isBreakInSpecialForm()) {
                    return StepValidity.invalid("Stepping to the exit level is not supported for special forms! \nSpecial forms do not have an exit point like regular functions do.");
                }
                if (br.isInScope(FunctionScope.FunctionExit)) {
                    return StepValidity.invalid("The current break is already at exit level!");
                }
                if (br.isInScope(FunctionScope.FunctionCall, FunctionScope.FunctionEntry)) {
                    return StepValidity.valid();
                }
                return StepValidity.invalid("Stepping to the exit level of the current function is only possible if the current function is in a break at call or entry level!");
            }
            case SteppingDisabled: {
                return StepValidity.valid();
            }
        }
        return StepValidity.invalid("Unsupported step mode: " + (Object)((Object)mode));
    }

    public String toString() {
        this.cleanBreaks();
        Step stepTmp = this.step;
        WaitableBreak br = this.getActiveWaitableBreak();
        StringBuilder sb = new StringBuilder();
        int padLen = 19;
        sb.append(String.format("%s %s\n", StringUtil.padRight("Active break:", 19), br == null ? "no" : "Break\n" + StringUtil.indent(br.toString(), 23)));
        if (this.breaks.size() > 1) {
            sb.append("All breaks:\n");
            AtomicLong idx = new AtomicLong(1L);
            this.breaks.forEach(b -> sb.append(String.format("%s %s\n", StringUtil.padRight(String.format("  [%d]:", idx.getAndIncrement()), 19), b.getBreak().getBreakFnInfo(false))));
        }
        sb.append(String.format("%s %s\n", StringUtil.padRight("Step mode:", 19), StepModeFormatter.format(stepTmp.mode())));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Step bound to fn:", 19), stepTmp.boundToFnName() == null ? "-" : stepTmp.boundToFnName()));
        sb.append(String.format("%s %d\n", StringUtil.padRight("Breakpoints:", 19), this.breakpoints.size()));
        sb.append(String.format("%s %s", StringUtil.padRight("Skip breakpoints:", 19), this.skipBreakpoints ? "yes" : "no"));
        return sb.toString();
    }

    private void handleBreak(Break br) {
        this.cleanBreaks();
        WaitableBreak wbr = new WaitableBreak(br, true);
        this.breaks.add(wbr);
        this.notifyOnBreak(wbr);
        this.waitOnBreak(wbr);
    }

    private void notifyOnBreak(WaitableBreak wbr) {
        if (this.breakListener != null) {
            this.breakListener.onBreak(wbr.getBreak());
        }
    }

    private void waitOnBreak(WaitableBreak wbr) {
        try {
            while (wbr.isWaitingOnBreak()) {
                Thread.sleep(500L);
            }
        }
        catch (java.lang.InterruptedException iex) {
            throw new InterruptedException(String.format("Interrupted while waiting for leaving breakpoint in function '%s'.", wbr.getBreak().getFn().getQualifiedName()));
        }
        finally {
            this.breaks.remove(wbr);
        }
    }

    private boolean isStopOnFunction(String fnName, boolean specialForm, FunctionScope scope) {
        Step stepTmp = this.step;
        switch (stepTmp.mode()) {
            case SteppingDisabled: {
                return this.skipBreakpoints ? false : this.matchesWithBreakpoint(fnName, specialForm, scope, this.breakpoints.get(new BreakpointFnRef(fnName)));
            }
            case StepToAny: {
                return true;
            }
            case StepToNextFunction: {
                return scope == FunctionScope.FunctionEntry;
            }
            case StepToNextNonSystemFunction: {
                return scope == FunctionScope.FunctionEntry && !this.hasSystemNS(fnName);
            }
            case StepToNextFunctionCall: {
                return scope == FunctionScope.FunctionCall;
            }
            case StepOverFunction: {
                if (scope == FunctionScope.FunctionExit && stepTmp.isBoundToFnNameOrNull(fnName)) {
                    this.step = new Step(StepMode.StepOverFunction_NextCall);
                }
                return false;
            }
            case StepOverFunction_NextCall: {
                if (scope == FunctionScope.FunctionCall && stepTmp.isBoundToFnNameOrNull(fnName)) {
                    this.step = new Step(StepMode.StepToFunctionEntry, fnName);
                }
                return false;
            }
            case StepToFunctionEntry: {
                return scope == FunctionScope.FunctionEntry && stepTmp.isBoundToFnNameOrNull(fnName);
            }
            case StepToFunctionExit: {
                return scope == FunctionScope.FunctionExit && stepTmp.isBoundToFnNameOrNull(fnName);
            }
        }
        return false;
    }

    private void clearAll() {
        this.step = this.step.clear();
        this.skipBreakpoints = false;
        this.breakpoints.clear();
        this.breaks.forEach(b -> b.stopWaitingOnBreak());
        this.breaks.clear();
    }

    private WaitableBreak getActiveWaitableBreak() {
        try {
            WaitableBreak br = this.breaks.get(0);
            return br.isWaitingOnBreak() ? br : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void cleanBreaks() {
        this.breaks.removeIf(b -> !b.isWaitingOnBreak());
    }

    private boolean hasSystemNS(String qualifiedName) {
        int pos = qualifiedName.indexOf(47);
        return pos < 1 ? true : Namespaces.isSystemNS(qualifiedName.substring(0, pos));
    }

    private boolean matchesWithBreakpoint(String fnName, boolean specialForm, FunctionScope scope, BreakpointFn bp) {
        if (bp != null) {
            for (Selector s : bp.getSelectors()) {
                boolean skipCallStackHead;
                if (!s.hasScope(scope)) continue;
                AncestorSelector as = s.getAncestorSelector();
                if (as == null) {
                    return true;
                }
                CallStack callStack = ThreadContext.get().getCallStack_();
                String ancestorQN = as.getAncestor().getQualifiedName();
                boolean bl = skipCallStackHead = scope != FunctionScope.FunctionCall && !specialForm;
                if (!(as.getType() == AncestorType.Nearest ? callStack.hasNearestAncestor(ancestorQN, skipCallStackHead) : callStack.hasAnyAncestor(ancestorQN, skipCallStackHead))) continue;
                return true;
            }
        }
        return false;
    }
}

