/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EachHelper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new EachHelper();
    public static final String NAME = "each";

    @Override
    public CharSequence apply(Object context, Options options) throws IOException {
        if (context == null) {
            return "";
        }
        if (context instanceof Iterable) {
            return this.iterableContext((Iterable)context, options);
        }
        return this.hashContext(context, options);
    }

    private CharSequence hashContext(Object context, Options options) throws IOException {
        Set<Map.Entry<String, Object>> propertySet = options.propertySet(context);
        Context parent = options.context;
        boolean first = true;
        Options.Buffer buffer = options.buffer();
        for (Map.Entry<String, Object> entry : propertySet) {
            Context current = Context.newBuilder(parent, entry.getValue()).combine("@key", entry.getKey()).combine("@first", first ? "first" : "").build();
            buffer.append(options.fn(current));
            first = false;
        }
        return buffer;
    }

    private CharSequence iterableContext(Iterable<Object> context, Options options) throws IOException {
        Options.Buffer buffer = options.buffer();
        if (options.isFalsy(context)) {
            buffer.append(options.inverse());
        } else {
            int base;
            Iterator<Object> iterator = context.iterator();
            int index = base = ((Integer)options.hash("base", 0)).intValue();
            Context parent = options.context;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                boolean even = index % 2 == 0;
                Context current = Context.newBuilder(parent, element).combine("@index", index).combine("@first", index == base ? "first" : "").combine("@last", !iterator.hasNext() ? "last" : "").combine("@odd", even ? "" : "odd").combine("@even", even ? "even" : "").combine("@index_1", index + 1).build();
                buffer.append(options.fn(current));
                current.destroy();
                ++index;
            }
        }
        return buffer;
    }
}

