/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsError;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.HelperResolver;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class Partial
extends HelperResolver {
    private Template path;
    private String context;
    private String startDelimiter;
    private String endDelimiter;
    private String indent;

    public Partial(Handlebars handlebars, Template path, String context, Map<String, Object> hash) {
        super(handlebars);
        this.path = (Template)Validate.notNull((Object)path, (String)"The path is required.", (Object[])new Object[0]);
        this.context = context;
        this.hash(hash);
    }

    @Override
    public void merge(Context context, Writer writer) throws IOException {
        TemplateLoader loader = this.handlebars.getLoader();
        try {
            LinkedList invocationStack = (LinkedList)context.data(Context.INVOCATION_STACK);
            String path = this.path.apply(context);
            TemplateSource source = loader.sourceAt(path);
            if (Partial.exists(invocationStack, source.filename())) {
                String message;
                String reason;
                TemplateSource caller = (TemplateSource)invocationStack.removeLast();
                Collections.reverse(invocationStack);
                if (invocationStack.isEmpty()) {
                    reason = String.format("infinite loop detected, partial '%s' is calling itself", source.filename());
                    message = String.format("%s:%s:%s: %s", caller.filename(), this.line, this.column, reason);
                } else {
                    reason = String.format("infinite loop detected, partial '%s' was previously loaded", source.filename());
                    message = String.format("%s:%s:%s: %s\n%s", caller.filename(), this.line, this.column, reason, "at " + StringUtils.join((Iterable)invocationStack, (String)"\nat "));
                }
                HandlebarsError error = new HandlebarsError(caller.filename(), this.line, this.column, reason, this.text(), message);
                throw new HandlebarsException(error);
            }
            if (this.indent != null) {
                source = Partial.partial(source, this.indent);
            }
            Template template = this.handlebars.compile(source);
            String key = StringUtils.isEmpty((CharSequence)this.context) ? "this" : this.context;
            template.apply(Context.newContext(context, context.get(key)).data(this.hash(context)), writer);
        }
        catch (IOException ex) {
            String reason = String.format("The partial '%s' could not be found", loader.resolve(this.path.text()));
            String message = String.format("%s:%s:%s: %s", this.filename, this.line, this.column, reason);
            HandlebarsError error = new HandlebarsError(this.filename, this.line, this.column, reason, this.text(), message);
            throw new HandlebarsException(error);
        }
    }

    private static boolean exists(List<TemplateSource> invocationStack, String filename) {
        for (TemplateSource ts : invocationStack) {
            if (!ts.filename().equals(filename)) continue;
            return true;
        }
        return false;
    }

    private static TemplateSource partial(final TemplateSource source, final String indent) {
        return new TemplateSource(){

            @Override
            public long lastModified() {
                return source.lastModified();
            }

            @Override
            public String filename() {
                return source.filename();
            }

            @Override
            public String content() throws IOException {
                return this.partialInput(source.content(), indent);
            }

            public int hashCode() {
                return source.hashCode();
            }

            public boolean equals(Object obj) {
                return source.equals(obj);
            }

            public String toString() {
                return source.toString();
            }

            private String partialInput(String input, String indent2) {
                StringBuilder buffer = new StringBuilder(input.length() + indent2.length());
                buffer.append(indent2);
                int len = input.length();
                for (int idx = 0; idx < len; ++idx) {
                    char ch = input.charAt(idx);
                    buffer.append(ch);
                    if (ch != '\n' || idx >= len - 1) continue;
                    buffer.append(indent2);
                }
                return buffer.toString();
            }
        };
    }

    @Override
    public String text() {
        StringBuilder buffer = new StringBuilder(this.startDelimiter).append('>').append(this.path.text());
        if (this.context != null) {
            buffer.append(' ').append(this.context);
        }
        buffer.append(this.endDelimiter);
        return buffer.toString();
    }

    public Partial endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Partial startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }

    public Partial indent(String indent) {
        this.indent = indent;
        return this;
    }
}

