/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Lambda;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.HelperResolver;
import com.github.jknack.handlebars.internal.Lambdas;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class Block
extends HelperResolver {
    private Template body;
    private final String name;
    private final boolean inverted;
    private final String type;
    private String startDelimiter;
    private String endDelimiter;
    private Template inverse;
    private String inverseLabel;

    public Block(Handlebars handlebars, String name, boolean inverted, List<Object> params, Map<String, Object> hash) {
        super(handlebars);
        this.name = (String)Validate.notNull((Object)name, (String)"The name is required.", (Object[])new Object[0]);
        this.inverted = inverted;
        this.type = inverted ? "^" : "#";
        this.params(params);
        this.hash(hash);
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        String helperName;
        Object childContext;
        if (this.body == null) {
            return;
        }
        Helper<Object> helper = this.helper(this.name);
        Template template = this.body;
        Context currentScope = context;
        if (helper == null) {
            childContext = this.transform(context.get(this.name));
            if (this.inverted) {
                helperName = "unless";
            } else if (childContext instanceof Iterable) {
                helperName = "each";
            } else if (childContext instanceof Boolean) {
                helperName = "if";
            } else if (childContext instanceof Lambda) {
                helperName = "with";
                template = Lambdas.compile(this.handlebars, (Lambda)childContext, context, template, this.startDelimiter, this.endDelimiter);
            } else {
                helperName = "with";
                currentScope = Context.newContext(context, childContext);
            }
            helper = this.handlebars.helper(helperName);
        } else {
            helperName = this.name;
            childContext = this.transform(this.determineContext(context));
        }
        Options options = new Options.Builder(this.handlebars, helperName, TagType.SECTION, currentScope, template).setInverse(this.inverse == null ? Template.EMPTY : this.inverse).setParams(this.params(currentScope)).setHash(this.hash(context)).build();
        options.data(Context.PARAM_SIZE, this.params.size());
        CharSequence result = helper.apply(childContext, options);
        if (!StringUtils.isEmpty((CharSequence)result)) {
            writer.append(result);
        }
    }

    public String name() {
        return this.name;
    }

    public boolean inverted() {
        return this.inverted;
    }

    public Block body(Template body) {
        this.body = (Template)Validate.notNull((Object)body, (String)"The template's body is required.", (Object[])new Object[0]);
        return this;
    }

    public Template inverse(String inverseLabel, Template inverse) {
        Validate.notNull((Object)inverseLabel, (String)"The inverseLabel can't be null.", (Object[])new Object[0]);
        Validate.isTrue((inverseLabel.equals("^") || inverseLabel.equals("else") ? 1 : 0) != 0, (String)"The inverseLabel must be one of '^' or 'else'.", (Object[])new Object[0]);
        this.inverseLabel = inverseLabel;
        this.inverse = (Template)Validate.notNull((Object)inverse, (String)"The inverse's template is required.", (Object[])new Object[0]);
        return this;
    }

    public Template inverse() {
        return this.inverse;
    }

    public Block endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Block startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public Template body() {
        return this.body;
    }

    @Override
    public String text() {
        return this.text(true);
    }

    private String text(boolean complete) {
        String hash;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.startDelimiter).append(this.type).append(this.name);
        String params = this.paramsToString();
        if (params.length() > 0) {
            buffer.append(" ").append(params);
        }
        if ((hash = this.hashToString()).length() > 0) {
            buffer.append(" ").append(hash);
        }
        buffer.append(this.endDelimiter);
        if (complete) {
            buffer.append(this.body == null ? "" : this.body.text());
            buffer.append(this.inverse == null ? "" : "{{" + this.inverseLabel + "}}" + this.inverse.text());
        } else {
            buffer.append("\n...\n");
        }
        buffer.append(this.startDelimiter).append('/').append(this.name).append(this.endDelimiter);
        return buffer.toString();
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        if (this.body != null) {
            LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
            tagNames.addAll(super.collect(tagType));
            tagNames.addAll(this.body.collect(tagType));
            return new ArrayList<String>(tagNames);
        }
        return super.collect(tagType);
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        if (tagType == TagType.SECTION) {
            result.add(this.name);
        }
        super.collect(result, tagType);
    }

    @Override
    public String toString() {
        return this.text(false);
    }
}

