/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.MissingValueResolver;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.ParserFactory;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.NullTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.helper.DefaultHelperRegistry;
import com.github.jknack.handlebars.internal.HbsParserFactory;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.CompositeTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handlebars
implements HelperRegistry {
    public static final String DELIM_START = "{{";
    public static final String DELIM_END = "}}";
    private static final Logger logger = LoggerFactory.getLogger(Handlebars.class);
    private TemplateLoader loader;
    private TemplateCache cache = NullTemplateCache.INSTANCE;
    private boolean stringParams;
    private boolean prettyPrint;
    private HelperRegistry registry = new DefaultHelperRegistry();
    private boolean infiniteLoops;
    private MissingValueResolver missingValueResolver = MissingValueResolver.NULL;
    private EscapingStrategy escapingStrategy = EscapingStrategy.HTML_ENTITY;
    private ParserFactory parserFactory = new HbsParserFactory();
    private String startDelimiter = "{{";
    private String endDelimiter = "}}";

    public Handlebars(TemplateLoader loader) {
        this.with(loader);
    }

    public Handlebars() {
        this(new ClassPathTemplateLoader());
    }

    public Template compile(String location) throws IOException {
        return this.compile(location, this.startDelimiter, this.endDelimiter);
    }

    public Template compile(String location, String startDelimiter, String endDelimiter) throws IOException {
        return this.compile(this.loader.sourceAt(location), startDelimiter, endDelimiter);
    }

    public Template compileInline(String input) throws IOException {
        return this.compileInline(input, this.startDelimiter, this.endDelimiter);
    }

    public Template compileInline(String input, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull((Object)input, (String)"The input is required.", (Object[])new Object[0]);
        String filename = "inline@" + Integer.toHexString(Math.abs(input.hashCode()));
        return this.compile(new StringTemplateSource(this.loader.resolve(filename), input), startDelimiter, endDelimiter);
    }

    public Template compile(TemplateSource source) throws IOException {
        return this.compile(source, this.startDelimiter, this.endDelimiter);
    }

    public Template compile(TemplateSource source, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull((Object)source, (String)"The template source is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)startDelimiter, (String)"The start delimiter is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)endDelimiter, (String)"The end delimiter is required.", (Object[])new Object[0]);
        Parser parser = this.parserFactory.create(this, startDelimiter, endDelimiter);
        Template template = this.cache.get(source, parser);
        return template;
    }

    @Override
    public <C> Helper<C> helper(String name) {
        return this.registry.helper(name);
    }

    @Override
    public <H> Handlebars registerHelper(String name, Helper<H> helper) {
        this.registry.registerHelper(name, helper);
        return this;
    }

    @Override
    public Handlebars registerHelpers(Object helperSource) {
        this.registry.registerHelpers(helperSource);
        return this;
    }

    @Override
    public Handlebars registerHelpers(Class<?> helperSource) {
        this.registry.registerHelpers(helperSource);
        return this;
    }

    @Override
    public Handlebars registerHelpers(URI location) throws Exception {
        this.registry.registerHelpers(location);
        return this;
    }

    @Override
    public Handlebars registerHelpers(File input) throws Exception {
        this.registry.registerHelpers(input);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String filename, Reader source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String filename, InputStream source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String filename, String source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.registry.helpers();
    }

    public TemplateLoader getLoader() {
        return this.loader;
    }

    public TemplateCache getCache() {
        return this.cache;
    }

    public MissingValueResolver getMissingValueResolver() {
        return this.missingValueResolver;
    }

    public EscapingStrategy getEscapingStrategy() {
        return this.escapingStrategy;
    }

    public boolean stringParams() {
        return this.stringParams;
    }

    public boolean prettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public HelperRegistry prettyPrint(boolean prettyPrint) {
        this.setPrettyPrint(prettyPrint);
        return this;
    }

    public void setStringParams(boolean stringParams) {
        this.stringParams = stringParams;
    }

    public HelperRegistry stringParams(boolean stringParams) {
        this.setStringParams(stringParams);
        return this;
    }

    public boolean infiniteLoops() {
        return this.infiniteLoops;
    }

    public void setInfiniteLoops(boolean infiniteLoops) {
        this.infiniteLoops = infiniteLoops;
    }

    public HelperRegistry infiniteLoops(boolean infiniteLoops) {
        this.setInfiniteLoops(infiniteLoops);
        return this;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = (String)Validate.notEmpty((CharSequence)endDelimiter, (String)"The endDelimiter is required.", (Object[])new Object[0]);
    }

    public Handlebars endDelimiter(String endDelimiter) {
        this.setEndDelimiter(endDelimiter);
        return this;
    }

    public void setStartDelimiter(String startDelimiter) {
        this.startDelimiter = (String)Validate.notEmpty((CharSequence)startDelimiter, (String)"The startDelimiter is required.", (Object[])new Object[0]);
    }

    public Handlebars startDelimiter(String startDelimiter) {
        this.setStartDelimiter(startDelimiter);
        return this;
    }

    public Handlebars with(TemplateLoader ... loader) {
        Validate.isTrue((loader.length > 0 ? 1 : 0) != 0, (String)"The template loader is required.", (Object[])new Object[0]);
        this.loader = loader.length == 1 ? loader[0] : new CompositeTemplateLoader(loader);
        return this;
    }

    public HelperRegistry with(ParserFactory parserFactory) {
        this.parserFactory = (ParserFactory)Validate.notNull((Object)parserFactory, (String)"A parserFactory is required.", (Object[])new Object[0]);
        return this;
    }

    public HelperRegistry with(TemplateCache cache) {
        this.cache = (TemplateCache)Validate.notNull((Object)cache, (String)"The template loader is required.", (Object[])new Object[0]);
        return this;
    }

    public Handlebars with(MissingValueResolver missingValueResolver) {
        this.missingValueResolver = (MissingValueResolver)Validate.notNull((Object)missingValueResolver, (String)"The missing value resolver is required.", (Object[])new Object[0]);
        return this;
    }

    public Handlebars with(HelperRegistry registry) {
        this.registry = (HelperRegistry)Validate.notNull((Object)registry, (String)"The registry is required.", (Object[])new Object[0]);
        return this;
    }

    public Handlebars with(EscapingStrategy escapingStrategy) {
        this.escapingStrategy = (EscapingStrategy)Validate.notNull((Object)escapingStrategy, (String)"The escaping strategy is required.", (Object[])new Object[0]);
        return this;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public static void log(String message, Object ... args) {
        logger.info(String.format(message, args));
    }

    public static void log(String message) {
        logger.info(message);
    }

    public static void warn(String message, Object ... args) {
        if (logger.isWarnEnabled()) {
            logger.warn(String.format(message, args));
        }
    }

    public static void warn(String message) {
        logger.warn(message);
    }

    public static void debug(String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(message, args));
        }
    }

    public static void debug(String message) {
        logger.debug(message);
    }

    public static void error(String message, Object ... args) {
        logger.error(String.format(message, args));
    }

    public static void error(String message) {
        logger.error(message);
    }

    public static class Utils {
        public static boolean isEmpty(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size() == 0;
            }
            if (value instanceof Iterable) {
                return !((Iterable)value).iterator().hasNext();
            }
            if (value instanceof Boolean) {
                return (Boolean)value == false;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) == 0;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() == 0;
            }
            return false;
        }

        public static String escapeExpression(CharSequence input) {
            if (StringUtils.isEmpty((CharSequence)input)) {
                return "";
            }
            if (input instanceof SafeString) {
                return input.toString();
            }
            StringBuilder html = new StringBuilder(input.length());
            block8: for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                switch (ch) {
                    case '<': {
                        html.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        html.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        html.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        html.append("&#x27;");
                        continue block8;
                    }
                    case '`': {
                        html.append("&#x60;");
                        continue block8;
                    }
                    case '&': {
                        html.append("&amp;");
                        continue block8;
                    }
                    default: {
                        html.append(ch);
                    }
                }
            }
            return html.toString();
        }
    }

    public static class SafeString
    implements CharSequence {
        private CharSequence content;

        public SafeString(CharSequence content) {
            this.content = content;
        }

        @Override
        public int length() {
            return this.content.length();
        }

        @Override
        public char charAt(int index) {
            return this.content.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.content.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.content.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SafeString) {
                SafeString that = (SafeString)obj;
                return this.content.equals(that.content);
            }
            return false;
        }
    }
}

