/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.TemplateLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.parboiled.common.Preconditions;

public class FileTemplateLoader
extends TemplateLoader {
    public FileTemplateLoader(File basedir, String suffix) {
        Preconditions.checkNotNull((Object)basedir, (Object)"The base dir is required.");
        Preconditions.checkArgument((boolean)basedir.exists(), (String)"File not found: %s", (Object[])new Object[]{basedir});
        Preconditions.checkArgument((boolean)basedir.isDirectory(), (String)"A directory is required: %s", (Object[])new Object[]{basedir});
        this.setPrefix(basedir.toString());
        this.setSuffix(suffix);
    }

    public FileTemplateLoader(File basedir) {
        this(basedir, ".hbs");
    }

    public FileTemplateLoader(String basedir, String suffix) {
        this.setPrefix(basedir);
        this.setSuffix(suffix);
    }

    public FileTemplateLoader(String basedir) {
        this(basedir, ".hbs");
    }

    @Override
    protected Reader read(String location) throws IOException {
        File file = new File(location);
        if (!file.exists()) {
            return null;
        }
        return new FileReader(file);
    }
}

