/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Lambda;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.DefaultOptions;
import com.github.jknack.handlebars.internal.HelperResolver;
import com.github.jknack.handlebars.internal.Lambdas;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class Variable
extends HelperResolver {
    private final String name;
    private final Type type;
    private final Object constant;

    public Variable(Handlebars handlebars, String name, Type type, List<Object> params, Map<String, Object> hash) {
        this(handlebars, name, null, type, params, hash);
    }

    public Variable(Handlebars handlebars, String name, Object value, Type type, List<Object> params, Map<String, Object> hash) {
        super(handlebars);
        this.name = name.trim();
        this.constant = value;
        this.type = type;
        this.params(params);
        this.hash(hash);
    }

    public Variable(Handlebars handlebars, String name, Object value, Type type) {
        this(handlebars, name, value, type, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
    }

    public String name() {
        return this.name;
    }

    @Override
    protected void merge(Context scope, Writer writer) throws IOException {
        Helper<Object> helper = this.helper(this.name);
        if (helper != null) {
            DefaultOptions options;
            Object context = this.determineContext(scope);
            CharSequence result = helper.apply(context, options = new DefaultOptions(this.handlebars, this, null, scope, this.params(scope), this.hash(scope)));
            if (this.escape(result)) {
                writer.append(Handlebars.Utils.escapeExpression(result));
            } else if (result != null) {
                writer.append(result);
            }
        } else {
            Object value;
            Object object = value = this.constant == null ? scope.get(this.name) : this.constant;
            if (value != null) {
                if (value instanceof Lambda) {
                    value = Lambdas.merge(this.handlebars, (Lambda)value, scope, this);
                }
                String stringValue = value.toString();
                if (this.escape(value)) {
                    writer.append(Handlebars.Utils.escapeExpression(stringValue));
                } else {
                    writer.append(stringValue);
                }
            }
        }
    }

    private boolean escape(Object value) {
        boolean isString;
        if (value instanceof Handlebars.SafeString) {
            return false;
        }
        boolean bl = isString = value instanceof CharSequence || value instanceof Character;
        if (isString) {
            return this.type.escape();
        }
        return false;
    }

    @Override
    public boolean remove(Template child) {
        return false;
    }

    @Override
    public String text() {
        return this.type.format(this.name, this.paramsToString(), this.hashToString());
    }

    static enum Type {
        TRIPLE_VAR{

            @Override
            public String start() {
                return "{{{";
            }

            @Override
            public String end() {
                return "}}}";
            }

            @Override
            public boolean escape() {
                return false;
            }
        }
        ,
        AMPERSAND_VAR{

            @Override
            public String start() {
                return "{{&";
            }

            @Override
            public boolean escape() {
                return false;
            }
        }
        ,
        VAR{

            @Override
            public boolean escape() {
                return true;
            }
        };


        public String start() {
            return "{{";
        }

        public String end() {
            return "}}";
        }

        public abstract boolean escape();

        public String format(String name, String params, String hash) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.start()).append(name);
            if (params.length() > 0) {
                buffer.append(" ").append(params);
            }
            if (hash.length() > 0) {
                buffer.append(" ").append(hash);
            }
            return buffer.append(this.end()).toString();
        }
    }
}

