/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EnumSet;

enum Transformer {
    NONE,
    ARRAY{

        @Override
        boolean apply(Object candidate) {
            return candidate != null && candidate.getClass().isArray();
        }

        @Override
        public Object doTransform(Object candidate) {
            int size = Array.getLength(candidate);
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(Array.get(candidate, i));
            }
            return list;
        }
    };


    boolean apply(Object candidate) {
        return false;
    }

    Object doTransform(Object candidate) {
        return candidate;
    }

    public static Object transform(Object canidate) {
        return Transformer.get(canidate).doTransform(canidate);
    }

    private static Transformer get(Object candidate) {
        EnumSet<Transformer> transoformers = EnumSet.allOf(Transformer.class);
        transoformers.remove((Object)NONE);
        for (Transformer transformer : transoformers) {
            if (!transformer.apply(candidate)) continue;
            return transformer;
        }
        return NONE;
    }
}

