/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.BaseTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TemplateList
extends BaseTemplate
implements Iterable<BaseTemplate> {
    private final List<BaseTemplate> nodes = new ArrayList<BaseTemplate>();

    TemplateList() {
    }

    public boolean add(BaseTemplate child) {
        boolean add = true;
        BaseTemplate candidate = child;
        if (candidate instanceof TemplateList) {
            TemplateList sequence = (TemplateList)candidate;
            if (sequence.size() == 0) {
                add = false;
            } else if (sequence.size() == 1) {
                candidate = sequence.iterator().next();
            }
        }
        if (add) {
            this.nodes.add(candidate);
        }
        return add;
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        for (BaseTemplate node : this.nodes) {
            node.apply(context, writer);
        }
    }

    @Override
    public String text() {
        StringBuilder buffer = new StringBuilder();
        for (BaseTemplate node : this.nodes) {
            buffer.append(node.text());
        }
        return buffer.toString();
    }

    @Override
    public Iterator<BaseTemplate> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public boolean remove(Template child) {
        boolean removed = this.nodes.remove(child);
        if (!removed) {
            Iterator<BaseTemplate> iterator = this.nodes.iterator();
            while (!removed && iterator.hasNext()) {
                removed = iterator.next().remove(child);
            }
        }
        return removed;
    }

    public int size() {
        return this.nodes.size();
    }
}

