/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.internal.Stacktrace;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Formatter;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.Position;

class ErrorFormatter
implements Formatter<InvalidInputError> {
    ErrorFormatter() {
    }

    public String format(InvalidInputError error) {
        String expectedString;
        if (error == null) {
            return "";
        }
        int len = error.getEndIndex() - error.getStartIndex();
        StringBuilder sb = new StringBuilder("found");
        if (len > 0) {
            sb.append(" '").append(StringUtils.escape((String)String.valueOf(error.getInputBuffer().charAt(error.getStartIndex()))));
            if (len > 1) {
                sb.append("...");
            }
            sb.append('\'');
        }
        if (StringUtils.isNotEmpty((String)(expectedString = this.getExpectedString(error)))) {
            sb.append(", expected: ").append(expectedString);
        }
        return sb.toString();
    }

    private String getExpectedString(InvalidInputError error) {
        int pathStartIndex = error.getStartIndex() - error.getIndexDelta();
        ArrayList<String> labelList = new ArrayList<String>();
        for (MatcherPath path : error.getFailedMatchers()) {
            String[] labels;
            Matcher labelMatcher = ErrorFormatter.findProperLabelMatcher(path, pathStartIndex);
            if (labelMatcher == null) continue;
            for (String label : labels = this.getLabels(labelMatcher)) {
                if (label == null) continue;
                for (String l : label.split("::")) {
                    if ("ignore".equals(l) || "text".equals(l) || "'{'".equals(l) || labelList.contains(l)) continue;
                    labelList.add(l);
                }
            }
        }
        return this.join(labelList);
    }

    private String[] getLabels(Matcher matcher) {
        if (matcher instanceof AnyOfMatcher && ((AnyOfMatcher)matcher).characters.toString().equals(matcher.getLabel())) {
            AnyOfMatcher cMatcher = (AnyOfMatcher)matcher;
            if (!cMatcher.characters.isSubtractive()) {
                String[] labels = new String[cMatcher.characters.getChars().length];
                for (int i = 0; i < labels.length; ++i) {
                    labels[i] = '\'' + String.valueOf(cMatcher.characters.getChars()[i]) + '\'';
                }
                return labels;
            }
        }
        return new String[]{matcher.getLabel()};
    }

    private String join(List<String> labelList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < labelList.size(); ++i) {
            String label;
            if (i > 0) {
                sb.append(i < labelList.size() - 1 ? ", " : " or ");
            }
            if ((label = labelList.get(i)).startsWith("'")) {
                sb.append(labelList.get(i));
                continue;
            }
            sb.append("'").append(labelList.get(i)).append("'");
        }
        return StringUtils.escape((String)sb.toString());
    }

    static Matcher findProperLabelMatcher(MatcherPath path, int errorIndex) {
        Matcher found;
        Preconditions.checkArgNotNull((Object)path, (String)"path");
        Matcher matcher = found = path.parent != null ? ErrorFormatter.findProperLabelMatcher(path.parent, errorIndex) : null;
        if (found != null) {
            return found;
        }
        if (path.element.startIndex == errorIndex && path.element.matcher.hasCustomLabel()) {
            return path.element.matcher;
        }
        return null;
    }

    public static String printParseError(String filename, ParseError error, int noffset, List<Stacktrace> stacktrace) {
        Preconditions.checkArgNotNull((Object)error, (String)"error");
        String message = (error.getErrorMessage() != null ? error.getErrorMessage() : (error instanceof InvalidInputError ? new ErrorFormatter().format((InvalidInputError)error) : "")).replace("EOI", "eof");
        return ErrorFormatter.printErrorMessage(filename, filename + ":%2$s:%3$s: %1$s", message, error.getStartIndex() - noffset, error.getEndIndex() - noffset, error.getInputBuffer(), stacktrace);
    }

    private static String printErrorMessage(String filename, String format, String errorMessage, int startIndex, int endIndex, InputBuffer inputBuffer, List<Stacktrace> stacktrace) {
        int i;
        Preconditions.checkArgNotNull((Object)inputBuffer, (String)"inputBuffer");
        Preconditions.checkArgument((startIndex <= endIndex ? 1 : 0) != 0);
        String nl = "\n";
        Position pos = inputBuffer.getPosition(startIndex);
        StringBuilder sb = new StringBuilder(String.format(format, errorMessage, pos.line, pos.column));
        sb.append(nl);
        String line = inputBuffer.extractLine(pos.line);
        String indent = "    ";
        sb.append(indent).append(line);
        sb.append(nl);
        int charCount = Math.max(Math.min(endIndex - startIndex, StringUtils.length((String)line) - pos.column + 2), 1);
        for (i = 0; i < pos.column - 1 + indent.length(); ++i) {
            sb.append(' ');
        }
        for (i = 0; i < charCount; ++i) {
            sb.append('^');
        }
        if (stacktrace.size() > 0) {
            boolean includeStack = true;
            LinkedHashSet<Stacktrace> set = new LinkedHashSet<Stacktrace>(stacktrace);
            if (set.size() == 1) {
                boolean bl = includeStack = !((Stacktrace)set.iterator().next()).getFilename().equals(filename);
            }
            if (includeStack) {
                sb.append(nl);
                for (Stacktrace st : set) {
                    sb.append(st).append(nl);
                }
                sb.setLength(sb.length() - nl.length());
            }
        }
        return sb.toString();
    }
}

