/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.TemplateCache;
import com.github.jknack.handlebars.TemplateLoader;
import com.github.jknack.handlebars.helper.BlockHelper;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.EachPseudoVarHelper;
import com.github.jknack.handlebars.helper.EmbeddedHelper;
import com.github.jknack.handlebars.helper.IfHelper;
import com.github.jknack.handlebars.helper.PartialHelper;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import com.github.jknack.handlebars.internal.Parser;
import com.github.jknack.handlebars.io.ClassTemplateLoader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.parboiled.common.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handlebars {
    private static final String DELIM_START = "{{";
    private static final String DELIM_END = "}}";
    private static final TemplateCache NO_CACHE = new TemplateCache(){

        @Override
        public void put(Object key, Template template) {
        }

        @Override
        public Template get(Object key) {
            return null;
        }

        @Override
        public void evict(Object key) {
        }

        @Override
        public void clear() {
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(Handlebars.class);
    private final TemplateLoader loader;
    private final TemplateCache cache;
    private final Map<String, Helper<Object>> helpers = new HashMap<String, Helper<Object>>();

    public Handlebars(TemplateLoader loader, TemplateCache cache) {
        this.loader = (TemplateLoader)Preconditions.checkNotNull((Object)loader, (Object)"The template loader is required.");
        this.cache = (TemplateCache)Preconditions.checkNotNull((Object)cache, (Object)"The template cache is required.");
        Handlebars.registerBuiltinsHelpers(this);
    }

    public Handlebars(TemplateLoader loader) {
        this(loader, NO_CACHE);
    }

    public Handlebars() {
        this(new ClassTemplateLoader(), NO_CACHE);
    }

    public Template compile(URI uri) throws IOException {
        return this.compile(uri, DELIM_START, DELIM_END);
    }

    public Template compile(URI uri, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull((Object)uri, (String)"The uri is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)uri.toString(), (String)"The uri is required.", (Object[])new Object[0]);
        return this.compile(uri.toString(), this.loader.loadAsString(uri), startDelimiter, endDelimiter);
    }

    public Template compile(String input) throws IOException {
        return this.compile(input, DELIM_START, DELIM_END);
    }

    public Template compile(String input, String startDelimiter, String endDelimiter) throws IOException {
        return this.compile("inline", input, startDelimiter, endDelimiter);
    }

    private Template compile(String filename, String input, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull((Object)input, (String)"The input text is required.", (Object[])new Object[0]);
        Handlebars.checkDelimiter(startDelimiter, "start");
        Handlebars.checkDelimiter(endDelimiter, "end");
        String key = filename + "@" + startDelimiter + input.hashCode() + endDelimiter;
        Handlebars.debug("Looking for: %s", key);
        Template template = this.cache.get(key);
        if (template == null) {
            Handlebars.debug("Key not found: %s", key);
            template = Parser.create(this, filename, startDelimiter, endDelimiter).parse(input);
            this.cache.put(key, template);
            Handlebars.debug("Key saved: %s", key);
        }
        return template;
    }

    public <H> Helper<H> helper(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"A helper's name is required.");
        return this.helpers.get(name);
    }

    public <H> Handlebars registerHelper(String name, Helper<H> helper) {
        Preconditions.checkNotNull((Object)name, (Object)"A helper's name is required.");
        Preconditions.checkNotNull(helper, (Object)"A helper is required.");
        this.helpers.put(name, helper);
        return this;
    }

    public Handlebars setExposePseudoVariables(boolean exposePseudoVariables) {
        if (exposePseudoVariables) {
            this.registerHelper("each", EachPseudoVarHelper.INSTANCE);
        }
        return this;
    }

    public TemplateLoader getTemplateLoader() {
        return this.loader;
    }

    public static void log(String message, Object ... args) {
        logger.info(String.format(message, args));
    }

    public static void log(String message) {
        logger.info(message);
    }

    public static void warn(String message, Object ... args) {
        if (logger.isWarnEnabled()) {
            logger.warn(String.format(message, args));
        }
    }

    public static void warn(String message) {
        logger.warn(message);
    }

    public static void debug(String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(message, args));
        }
    }

    public static void debug(String message) {
        logger.debug(message);
    }

    public static void error(String message, Object ... args) {
        logger.error(String.format(message, args));
    }

    public static void error(String message) {
        logger.error(message);
    }

    private static void checkDelimiter(String delimiter, String type) {
        Validate.notNull((Object)delimiter, (String)"The %s delimiter is required.", (Object[])new Object[]{type});
        Validate.notEmpty((CharSequence)delimiter, (String)"The %s delimiter is required.", (Object[])new Object[]{type});
    }

    private static void registerBuiltinsHelpers(Handlebars handlebars) {
        handlebars.registerHelper("with", WithHelper.INSTANCE);
        handlebars.registerHelper("if", IfHelper.INSTANCE);
        handlebars.registerHelper("unless", UnlessHelper.INSTANCE);
        handlebars.registerHelper("each", EachHelper.INSTANCE);
        handlebars.registerHelper("embedded", EmbeddedHelper.INSTANCE);
        handlebars.registerHelper("block", BlockHelper.INSTANCE);
        handlebars.registerHelper("partial", PartialHelper.INSTANCE);
    }

    static {
        Parser.initialize();
    }

    public static class Utils {
        public static boolean isEmpty(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size() == 0;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) == 0;
            }
            if (value instanceof Iterable) {
                return !((Iterable)value).iterator().hasNext();
            }
            if (value instanceof Boolean) {
                return (Boolean)value == false;
            }
            return false;
        }

        public static String escapeExpression(CharSequence input) {
            if (input == null || input.length() == 0) {
                return "";
            }
            if (input instanceof SafeString) {
                return ((Object)input).toString();
            }
            StringBuilder html = new StringBuilder(input.length());
            block8: for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                switch (ch) {
                    case '<': {
                        html.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        html.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        html.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        html.append("&#x27;");
                        continue block8;
                    }
                    case '`': {
                        html.append("&#x60;");
                        continue block8;
                    }
                    case '&': {
                        html.append("&amp;");
                        continue block8;
                    }
                    default: {
                        html.append(ch);
                    }
                }
            }
            return html.toString();
        }
    }

    public static class SafeString
    implements CharSequence {
        private CharSequence content;

        public SafeString(CharSequence content) {
            this.content = content;
        }

        @Override
        public int length() {
            return this.content.length();
        }

        @Override
        public char charAt(int index) {
            return this.content.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.content.subSequence(start, end);
        }

        @Override
        public String toString() {
            return ((Object)this.content).toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SafeString) {
                SafeString that = (SafeString)obj;
                return this.content.equals(that.content);
            }
            return false;
        }
    }
}

