/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;

public class MethodHelper
implements Helper<Object> {
    private Object source;
    private Method method;

    public MethodHelper(Method method, Object source) {
        this.method = (Method)Validate.notNull((Object)method, (String)"A helper method is required.", (Object[])new Object[0]);
        this.source = source;
    }

    @Override
    public CharSequence apply(Object context, Options options) throws IOException {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        ArrayList<Object> args = new ArrayList<Object>();
        int pidx = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            Object arg = null;
            if (i == 0 && paramType.isInstance(context)) {
                arg = context;
            }
            if (arg == null && context != null) {
                arg = options.param(pidx, null);
                if (arg == null) {
                    if (paramType.isInstance(options)) {
                        arg = options;
                    }
                } else {
                    Validate.isTrue((paramType.isInstance(arg) || paramType.isAssignableFrom(MethodHelper.unwrap(arg.getClass())) ? 1 : 0) != 0, (String)"found '%s', expected '%s'", (Object[])new Object[]{arg.getClass().getName(), paramType.getName()});
                    ++pidx;
                }
            }
            args.add(arg);
        }
        try {
            return (CharSequence)this.method.invoke(this.source, args.toArray(new Object[args.size()]));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IllegalStateException("could not execute helper: " + this.method.getName(), ex);
        }
    }

    private static Class<?> unwrap(Class<?> clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        return clazz;
    }
}

