/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.MissingValueResolver;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.ParserFactory;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.NullTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.helper.BlockHelper;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.EmbeddedHelper;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.helper.IfHelper;
import com.github.jknack.handlebars.helper.IncludeHelper;
import com.github.jknack.handlebars.helper.MethodHelper;
import com.github.jknack.handlebars.helper.PartialHelper;
import com.github.jknack.handlebars.helper.PrecompileHelper;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import com.github.jknack.handlebars.internal.HbsParserFactory;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handlebars {
    public static final String HELPER_MISSING = "helperMissing";
    public static final String DELIM_START = "{{";
    public static final String DELIM_END = "}}";
    private static final Logger logger = LoggerFactory.getLogger(Handlebars.class);
    private TemplateLoader loader;
    private TemplateCache cache;
    private boolean stringParams;
    private boolean prettyWhitespaces;
    private final Map<String, Helper<Object>> helpers = new HashMap<String, Helper<Object>>();
    private boolean allowInfiniteLoops;
    private MissingValueResolver missingValueResolver = MissingValueResolver.NULL;
    private ParserFactory parserFactory = new HbsParserFactory();

    public Handlebars(TemplateLoader loader, TemplateCache cache) {
        Handlebars.registerBuiltinsHelpers(this);
        this.with(loader);
        this.with(cache);
    }

    public Handlebars(TemplateLoader loader) {
        this(loader, NullTemplateCache.INSTANCE);
    }

    public Handlebars() {
        this(new ClassPathTemplateLoader(), NullTemplateCache.INSTANCE);
    }

    public Template compile(URI uri) throws IOException {
        return this.compile(uri, DELIM_START, DELIM_END);
    }

    public Template compile(URI uri, String startDelimiter, String endDelimiter) throws IOException {
        return this.compile(this.loader.sourceAt(uri), startDelimiter, endDelimiter);
    }

    public Template compile(String input) throws IOException {
        return this.compile(input, DELIM_START, DELIM_END);
    }

    public Template compile(String input, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull((Object)input, (String)"The input is required.", (Object[])new Object[0]);
        String filename = "inline@" + Integer.toHexString(Math.abs(input.hashCode()));
        return this.compile(new StringTemplateSource(this.loader.resolve(URI.create(filename)), input), startDelimiter, endDelimiter);
    }

    public Template compile(TemplateSource source) throws IOException {
        return this.compile(source, DELIM_START, DELIM_END);
    }

    public Template compile(TemplateSource source, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull((Object)source, (String)"The template source is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)startDelimiter, (String)"The start delimiter is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)endDelimiter, (String)"The end delimiter is required.", (Object[])new Object[0]);
        Parser parser = this.parserFactory.create(this, startDelimiter, endDelimiter);
        Template template = this.cache.get(source, parser);
        return template;
    }

    public <C> Helper<C> helper(String name) {
        Validate.notEmpty((CharSequence)name, (String)"A helper's name is required.", (Object[])new Object[0]);
        return this.helpers.get(name);
    }

    public <H> Handlebars registerHelper(String name, Helper<H> helper) {
        Validate.notEmpty((CharSequence)name, (String)"A helper's name is required.", (Object[])new Object[0]);
        Validate.notNull(helper, (String)"A helper is required.", (Object[])new Object[0]);
        Helper<H> oldHelper = this.helpers.put(name, helper);
        if (oldHelper != null) {
            Handlebars.warn("Helper '%s': %s has been replaced by %s", name, oldHelper, helper);
        }
        return this;
    }

    public Handlebars registerHelpers(Object helperSource) {
        Validate.notNull((Object)helperSource, (String)"The helper source is required.", (Object[])new Object[0]);
        this.registerDynamicHelper(helperSource, helperSource.getClass());
        return this;
    }

    public Handlebars registerHelpers(Class<?> helperSource) {
        Validate.notNull(helperSource, (String)"The helper source is required.", (Object[])new Object[0]);
        this.registerDynamicHelper(null, helperSource);
        return this;
    }

    private void registerDynamicHelper(Object source, Class<?> clazz) {
        int size = this.helpers.size();
        if (clazz != Object.class) {
            Method[] methods;
            HashSet<String> overloaded = new HashSet<String>();
            for (Method method : methods = clazz.getDeclaredMethods()) {
                boolean isPublic = Modifier.isPublic(method.getModifiers());
                String helperName = method.getName();
                if (!isPublic || !CharSequence.class.isAssignableFrom(method.getReturnType())) continue;
                boolean isStatic = Modifier.isStatic(method.getModifiers());
                if (source == null && !isStatic) continue;
                Validate.isTrue((boolean)overloaded.add(helperName), (String)("name conflict found: " + helperName), (Object[])new Object[0]);
                this.registerHelper(helperName, new MethodHelper(method, source));
            }
        }
        Validate.isTrue((size != this.helpers.size() ? 1 : 0) != 0, (String)("No helper method was found in: " + clazz.getName()), (Object[])new Object[0]);
    }

    public TemplateLoader getLoader() {
        return this.loader;
    }

    public TemplateCache getCache() {
        return this.cache;
    }

    public MissingValueResolver getMissingValueResolver() {
        return this.missingValueResolver;
    }

    public boolean allowStringParams() {
        return this.stringParams;
    }

    public boolean prettyWhitespaces() {
        return this.prettyWhitespaces;
    }

    public void setPrettyWhitespaces(boolean prettyWhitespaces) {
        this.prettyWhitespaces = prettyWhitespaces;
    }

    public void setStringParams(boolean stringParams) {
        this.stringParams = stringParams;
    }

    public boolean allowInfiniteLoops() {
        return this.allowInfiniteLoops;
    }

    public void setAllowInfiniteLoops(boolean allowInfiniteLoops) {
        this.allowInfiniteLoops = allowInfiniteLoops;
    }

    public Handlebars with(TemplateLoader loader) {
        this.loader = (TemplateLoader)Validate.notNull((Object)loader, (String)"The template loader is required.", (Object[])new Object[0]);
        return this;
    }

    public Handlebars with(ParserFactory parserFactory) {
        this.parserFactory = (ParserFactory)Validate.notNull((Object)parserFactory, (String)"A parserFactory is required.", (Object[])new Object[0]);
        return this;
    }

    public Handlebars with(TemplateCache cache) {
        this.cache = (TemplateCache)Validate.notNull((Object)cache, (String)"The template loader is required.", (Object[])new Object[0]);
        return this;
    }

    public Handlebars with(MissingValueResolver missingValueResolver) {
        this.missingValueResolver = (MissingValueResolver)Validate.notNull((Object)missingValueResolver, (String)"The missing value resolver is required.", (Object[])new Object[0]);
        return this;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public static void log(String message, Object ... args) {
        logger.info(String.format(message, args));
    }

    public static void log(String message) {
        logger.info(message);
    }

    public static void warn(String message, Object ... args) {
        if (logger.isWarnEnabled()) {
            logger.warn(String.format(message, args));
        }
    }

    public static void warn(String message) {
        logger.warn(message);
    }

    public static void debug(String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(message, args));
        }
    }

    public static void debug(String message) {
        logger.debug(message);
    }

    public static void error(String message, Object ... args) {
        logger.error(String.format(message, args));
    }

    public static void error(String message) {
        logger.error(message);
    }

    private static void registerBuiltinsHelpers(Handlebars handlebars) {
        handlebars.registerHelper("with", WithHelper.INSTANCE);
        handlebars.registerHelper("if", IfHelper.INSTANCE);
        handlebars.registerHelper("unless", UnlessHelper.INSTANCE);
        handlebars.registerHelper("each", EachHelper.INSTANCE);
        handlebars.registerHelper("embedded", EmbeddedHelper.INSTANCE);
        handlebars.registerHelper("block", BlockHelper.INSTANCE);
        handlebars.registerHelper("partial", PartialHelper.INSTANCE);
        handlebars.registerHelper("include", IncludeHelper.INSTANCE);
        handlebars.registerHelper("precompile", PrecompileHelper.INSTANCE);
        I18nHelper.registerHelpers(handlebars);
    }

    public static class Utils {
        public static boolean isEmpty(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size() == 0;
            }
            if (value instanceof Iterable) {
                return !((Iterable)value).iterator().hasNext();
            }
            if (value instanceof Boolean) {
                return (Boolean)value == false;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) == 0;
            }
            return false;
        }

        public static String escapeExpression(CharSequence input) {
            if (input == null || input.length() == 0) {
                return "";
            }
            if (input instanceof SafeString) {
                return ((Object)input).toString();
            }
            StringBuilder html = new StringBuilder(input.length());
            block8: for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                switch (ch) {
                    case '<': {
                        html.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        html.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        html.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        html.append("&#x27;");
                        continue block8;
                    }
                    case '`': {
                        html.append("&#x60;");
                        continue block8;
                    }
                    case '&': {
                        html.append("&amp;");
                        continue block8;
                    }
                    default: {
                        html.append(ch);
                    }
                }
            }
            return html.toString();
        }
    }

    public static class SafeString
    implements CharSequence {
        private CharSequence content;

        public SafeString(CharSequence content) {
            this.content = content;
        }

        @Override
        public int length() {
            return this.content.length();
        }

        @Override
        public char charAt(int index) {
            return this.content.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.content.subSequence(start, end);
        }

        @Override
        public String toString() {
            return ((Object)this.content).toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SafeString) {
                SafeString that = (SafeString)obj;
                return this.content.equals(that.content);
            }
            return false;
        }
    }
}

