/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.ParserFactory;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.HbsErrorReporter;
import com.github.jknack.handlebars.internal.HbsErrorStrategy;
import com.github.jknack.handlebars.internal.HbsLexer;
import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.Partial;
import com.github.jknack.handlebars.internal.SpaceTrimmer;
import com.github.jknack.handlebars.internal.Stacktrace;
import com.github.jknack.handlebars.internal.TemplateBuilder;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class HbsParserFactory
implements ParserFactory {
    public Parser create(final Handlebars handlebars, final String filename, final String startDelimiter, final String endDelimiter, final Map<String, Partial> partials, final LinkedList<Stacktrace> stacktrace) {
        return new Parser(){

            @Override
            public Template parse(String input) {
                String fname = handlebars.getTemplateLoader().resolve(filename);
                ANTLRInputStream stream = new ANTLRInputStream(input);
                stream.name = fname;
                final HbsErrorReporter errorReporter = new HbsErrorReporter(stream.name);
                final HbsLexer lexer = new HbsLexer((CharStream)stream, startDelimiter, endDelimiter){

                    public void notifyListeners(LexerNoViableAltException e) {
                        String text = this._input.getText(Interval.of((int)this._tokenStartCharIndex, (int)this._input.index()));
                        String msg = "found: '" + this.getErrorDisplay(text) + "'";
                        ANTLRErrorListener listener = this.getErrorListenerDispatch();
                        listener.syntaxError((Recognizer)this, null, this._tokenStartLine, this._tokenStartCharPositionInLine, msg, (RecognitionException)e);
                    }

                    public void recover(LexerNoViableAltException e) {
                        throw new IllegalArgumentException((Throwable)e);
                    }
                };
                lexer.removeErrorListeners();
                lexer.addErrorListener(errorReporter);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                final HbsParser parser = new HbsParser((TokenStream)tokens){

                    @Override
                    void setStart(String start) {
                        lexer.start = start;
                    }

                    @Override
                    void setEnd(String end) {
                        lexer.end = end;
                    }
                };
                parser.removeErrorListeners();
                parser.addErrorListener(errorReporter);
                parser.setErrorHandler((ANTLRErrorStrategy)new HbsErrorStrategy());
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                HbsParser.TemplateContext tree = parser.template();
                if (handlebars.prettyWhitespaces()) {
                    new ParseTreeWalker().walk((ParseTreeListener)new SpaceTrimmer(), (ParseTree)tree);
                }
                TemplateBuilder builder = new TemplateBuilder(handlebars, fname, partials, stacktrace){

                    @Override
                    protected void reportError(CommonToken offendingToken, int line, int column, String message) {
                        errorReporter.syntaxError((Recognizer)parser, (Object)offendingToken, line, column, message, null);
                    }
                };
                Template template = builder.visit((ParseTree)tree);
                return template;
            }
        };
    }

    @Override
    public Parser create(Handlebars handlebars, String filename, String startDelimiter, String endDelimiter) {
        return this.create(handlebars, filename, startDelimiter, endDelimiter, null, null);
    }
}

