/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.context;

import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.MemberValueResolver;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;

public class FieldValueResolver
extends MemberValueResolver<Field> {
    public static final ValueResolver INSTANCE = new FieldValueResolver();

    @Override
    public boolean matches(Field field, String name) {
        return !this.isStatic(field) && field.getName().equals(name);
    }

    @Override
    protected Object invokeMember(Field field, Object context) {
        try {
            return field.get(context);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "'", ex);
        }
    }

    @Override
    protected Set<Field> members(Class<?> clazz) {
        LinkedHashSet<Field> members = new LinkedHashSet<Field>();
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                if (!this.matches(field, this.memberName(field))) continue;
                members.add(field);
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return members;
    }

    @Override
    protected String memberName(Field member) {
        return member.getName();
    }
}

