/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.Validate;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageSourceHelper
implements Helper<String> {
    private MessageSource messageSource;

    public MessageSourceHelper(MessageSource messageSource) {
        this.messageSource = (MessageSource)Validate.notNull((Object)messageSource, (String)"A message source is required.", (Object[])new Object[0]);
    }

    public Object apply(String code, Options options) throws IOException {
        Object[] args = options.params;
        String defaultMessage = (String)options.hash("default");
        return this.messageSource.getMessage(code, args, defaultMessage, this.currentLocale());
    }

    protected Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }
}

