/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.helper.DefaultHelperRegistry;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.helper.I18nSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.URLTemplateLoader;
import com.github.jknack.handlebars.springmvc.HandlebarsView;
import com.github.jknack.handlebars.springmvc.MessageSourceHelper;
import com.github.jknack.handlebars.springmvc.SpringTemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class HandlebarsViewResolver
extends AbstractTemplateViewResolver
implements InitializingBean,
HelperRegistry {
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private Handlebars handlebars;
    private ValueResolver[] valueResolvers = ValueResolver.VALUE_RESOLVERS;
    private boolean failOnMissingFile = true;
    private HelperRegistry registry = new DefaultHelperRegistry();
    private boolean registerMessageHelper = true;
    private boolean bindI18nToMessageSource;

    public HandlebarsViewResolver(Class<? extends HandlebarsView> viewClass) {
        this.setViewClass(viewClass);
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setPrefix("/");
        this.setSuffix(".hbs");
    }

    public HandlebarsViewResolver() {
        this(HandlebarsView.class);
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        return this.configure((HandlebarsView)super.buildView(viewName));
    }

    protected AbstractUrlBasedView configure(HandlebarsView view) throws IOException {
        String url = view.getUrl();
        url = url.substring(this.getPrefix().length(), url.length() - this.getSuffix().length());
        try {
            view.setTemplate(this.handlebars.compile(url));
            view.setValueResolver(this.valueResolvers);
        }
        catch (IOException ex) {
            if (this.failOnMissingFile) {
                throw ex;
            }
            this.logger.debug((Object)("File not found: " + url));
        }
        return view;
    }

    protected Class<?> requiredViewClass() {
        return HandlebarsView.class;
    }

    public void afterPropertiesSet() {
        URLTemplateLoader templateLoader = this.createTemplateLoader(this.getApplicationContext());
        this.handlebars = (Handlebars)Validate.notNull((Object)this.createHandlebars(templateLoader), (String)"A handlebars object is required.", (Object[])new Object[0]);
        this.handlebars.with(this.registry);
        if (this.registerMessageHelper) {
            this.handlebars.registerHelper("message", (Helper)new MessageSourceHelper((MessageSource)this.getApplicationContext()));
        }
        if (this.bindI18nToMessageSource) {
            I18nSource i18nSource = HandlebarsViewResolver.createI18nSource(this.getApplicationContext());
            I18nHelper.i18n.setSource(i18nSource);
            I18nHelper.i18nJs.setSource(i18nSource);
        }
    }

    private static I18nSource createI18nSource(final ApplicationContext context) {
        return new I18nSource(){

            public String message(String key, Locale locale, Object ... args) {
                return context.getMessage(key, args, locale);
            }

            public String[] keys(String basename, Locale locale) {
                ResourceBundle bundle = ResourceBundle.getBundle(basename, locale);
                Enumeration<String> keys = bundle.getKeys();
                ArrayList<String> result = new ArrayList<String>();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    result.add(key);
                }
                return result.toArray(new String[result.size()]);
            }
        };
    }

    protected Handlebars createHandlebars(URLTemplateLoader templateLoader) {
        return new Handlebars((TemplateLoader)templateLoader);
    }

    protected URLTemplateLoader createTemplateLoader(ApplicationContext context) {
        SpringTemplateLoader templateLoader = new SpringTemplateLoader(context);
        templateLoader.setPrefix(this.getPrefix());
        templateLoader.setSuffix(this.getSuffix());
        return templateLoader;
    }

    public Handlebars getHandlebars() {
        if (this.handlebars == null) {
            throw new IllegalStateException("afterPropertiesSet() method hasn't been call it.");
        }
        return this.handlebars;
    }

    public void setValueResolvers(ValueResolver ... valueResolvers) {
        this.valueResolvers = (ValueResolver[])Validate.notEmpty((Object[])valueResolvers, (String)"At least one value-resolver must be present.", (Object[])new Object[0]);
    }

    public void setFailOnMissingFile(boolean failOnMissingFile) {
        this.failOnMissingFile = failOnMissingFile;
    }

    public void setHelpers(Map<String, Helper<?>> helpers) {
        Validate.notNull(helpers, (String)"The helpers are required.", (Object[])new Object[0]);
        for (Map.Entry<String, Helper<?>> helper : helpers.entrySet()) {
            this.registry.registerHelper(helper.getKey(), helper.getValue());
        }
    }

    public void setHelpers(List<Object> helpers) {
        Validate.notNull(helpers, (String)"The helpers are required.", (Object[])new Object[0]);
        for (Object helper : helpers) {
            this.registry.registerHelpers(helper);
        }
    }

    public HandlebarsViewResolver registerHelpers(Object helperSource) {
        this.registry.registerHelpers(helperSource);
        return this;
    }

    public HandlebarsViewResolver registerHelpers(Class<?> helperSource) {
        this.registry.registerHelpers(helperSource);
        return this;
    }

    public <C> Helper<C> helper(String name) {
        return this.registry.helper(name);
    }

    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.registry.helpers();
    }

    public <H> HandlebarsViewResolver registerHelper(String name, Helper<H> helper) {
        this.registry.registerHelper(name, helper);
        return this;
    }

    public HandlebarsViewResolver registerHelpers(URI location) throws Exception {
        this.registry.registerHelpers(location);
        return this;
    }

    public HandlebarsViewResolver registerHelpers(File input) throws Exception {
        this.registry.registerHelpers(input);
        return this;
    }

    public HandlebarsViewResolver registerHelpers(String filename, Reader source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    public HandlebarsViewResolver registerHelpers(String filename, InputStream source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    public HandlebarsViewResolver registerHelpers(String filename, String source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    public HandlebarsViewResolver withoutMessageHelper() {
        this.setRegisterMessageHelper(false);
        return this;
    }

    public void setRegisterMessageHelper(boolean registerMessageHelper) {
        this.registerMessageHelper = registerMessageHelper;
    }

    public void setBindI18nToMessageSource(boolean bindI18nToMessageSource) {
        this.bindI18nToMessageSource = bindI18nToMessageSource;
    }
}

