/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.TemplateLoader;
import com.github.jknack.handlebars.springmvc.HandlebarsView;
import java.io.IOException;
import java.net.URI;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class HandlebarsViewResolver
extends AbstractTemplateViewResolver {
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private Handlebars handlebars;

    public HandlebarsViewResolver(Handlebars handlebars) {
        Assert.notNull((Object)handlebars, (String)"The handlebars object is required.");
        this.handlebars = handlebars;
        this.setViewClass(HandlebarsView.class);
        this.setContentType(DEFAULT_CONTENT_TYPE);
    }

    public void setPrefix(String prefix) {
        throw new UnsupportedOperationException("Use " + TemplateLoader.class.getName() + "#setPrefix");
    }

    public void setSuffix(String suffix) {
        throw new UnsupportedOperationException("Use " + TemplateLoader.class.getName() + "#setSuffix");
    }

    public HandlebarsViewResolver() {
        this(new Handlebars());
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        return this.configure((HandlebarsView)super.buildView(viewName));
    }

    protected AbstractUrlBasedView configure(HandlebarsView view) throws IOException {
        String url = view.getUrl();
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        URI uri = URI.create(url);
        Template template = this.handlebars.compile(uri);
        view.setTemplate(template);
        return view;
    }

    protected Class<?> requiredViewClass() {
        return HandlebarsView.class;
    }
}

