/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.io.URLTemplateLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.Validate;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringTemplateLoader
extends URLTemplateLoader {
    private ResourceLoader loader;

    public SpringTemplateLoader(ResourceLoader loader) {
        this.loader = (ResourceLoader)Validate.notNull((Object)loader, (String)"A resource loader is required.", (Object[])new Object[0]);
    }

    public SpringTemplateLoader(ApplicationContext applicationContext) {
        this((ResourceLoader)applicationContext);
    }

    protected URL getResource(String location) throws IOException {
        Resource resource = this.loader.getResource(location);
        if (!resource.exists()) {
            throw new FileNotFoundException(location);
        }
        return resource.getURL();
    }

    public String resolve(String location) {
        String protocol = null;
        if (location.startsWith("classpath:")) {
            protocol = "classpath:";
        } else if (location.startsWith("file:")) {
            protocol = "file:";
        }
        if (protocol == null) {
            return super.resolve(location);
        }
        return protocol + super.resolve(location.substring(protocol.length()));
    }
}

