/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.io.URLTemplateLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.Validate;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringTemplateLoader
extends URLTemplateLoader {
    private ResourceLoader loader;

    public SpringTemplateLoader(ResourceLoader loader) {
        this.loader = (ResourceLoader)Validate.notNull((Object)loader, (String)"A resource loader is required.", (Object[])new Object[0]);
    }

    public SpringTemplateLoader(ApplicationContext applicationContext) {
        this((ResourceLoader)applicationContext);
    }

    protected URL getResource(String location) throws IOException {
        Resource resource = this.loader.getResource(location);
        if (!resource.exists()) {
            throw new FileNotFoundException(location);
        }
        return resource.getURL();
    }

    public String resolve(URI uri) {
        String protocol = null;
        String location = uri.toString();
        if (location.startsWith("classpath:")) {
            protocol = "classpath:";
        } else if (location.startsWith("file:")) {
            protocol = "file:";
        }
        if (protocol == null) {
            return super.resolve(uri);
        }
        return protocol + super.resolve(URI.create(location.substring(protocol.length())));
    }
}

