/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.maven;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.maven.HandlebarsPlugin;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="i18njs", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class I18nJsPlugin
extends HandlebarsPlugin {
    @Parameter
    private String bundle = "messages";
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/js")
    private String output;
    @Parameter(defaultValue="false")
    private boolean merge;
    @Parameter
    private boolean amd;
    @Parameter(defaultValue="UTF-8")
    private String encoding = "UTF-8";

    @Override
    protected void doExecute() throws Exception {
        Validate.notNull((Object)this.bundle, (String)"The bundle's name parameter is required.", (Object[])new Object[0]);
        Validate.notNull((Object)this.output, (String)"The output parameter is required.", (Object[])new Object[0]);
        Handlebars handlebars = new Handlebars();
        handlebars.setCharset(Charset.forName(this.encoding));
        Context context = Context.newContext(null);
        Object[] classpath = this.projectClasspath();
        new File(this.output).mkdirs();
        this.getLog().info((CharSequence)"Converting bundles...");
        this.getLog().debug((CharSequence)"Options:");
        this.getLog().debug((CharSequence)("  output: " + this.output));
        this.getLog().debug((CharSequence)("  merge: " + this.merge));
        this.getLog().debug((CharSequence)("  amd: " + this.amd));
        this.getLog().debug((CharSequence)("  classpath: " + StringUtils.join((Object[])classpath, (String)File.pathSeparator)));
        StringBuilder buffer = new StringBuilder();
        List<File> bundles = this.bundles(this.bundle, (URL[])classpath);
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("wrap", false);
        if (classpath.length > 0) {
            hash.put("classLoader", new URLClassLoader((URL[])classpath, ((Object)((Object)this)).getClass().getClassLoader()));
        }
        String basename = FileUtils.removePath((String)this.bundle.replace(".", FileUtils.FS));
        Collections.sort(bundles);
        for (File bundle : bundles) {
            String bundleName = FileUtils.removeExtension((String)bundle.getName());
            this.getLog().debug((CharSequence)("converting: " + bundle.getName()));
            String locale = bundleName.substring(basename.length());
            if (locale.startsWith("_")) {
                locale = locale.substring(1);
            }
            hash.put("bundle", this.bundle);
            Options options = new Options.Builder(handlebars, I18nHelper.i18nJs.name(), TagType.VAR, context, Template.EMPTY).setHash(hash).build();
            buffer.append(I18nHelper.i18nJs.apply((Object)locale, options));
            if (!this.merge) {
                FileUtils.fileWrite((File)new File(this.output, bundleName + ".js"), (String)this.encoding, (String)this.wrap(bundleName, buffer, this.amd));
                buffer.setLength(0);
                this.getLog().debug((CharSequence)("  => " + bundleName + ".js"));
                continue;
            }
            buffer.append("\n");
        }
        if (this.merge && buffer.length() > 0) {
            FileUtils.fileWrite((File)new File(this.output, basename + ".js"), (String)this.wrap(basename, buffer, this.amd));
            this.getLog().debug((CharSequence)("  =>" + basename + ".js"));
        }
    }

    private String wrap(String filename, CharSequence body, boolean amd) {
        if (amd) {
            return String.format("define('%s', ['i18n'], function (I18n) {\n%s});\n", filename, body);
        }
        return String.format("(function() {\n%s})();\n", body.toString());
    }

    private List<File> bundles(String bundle, URL[] classpath) throws Exception {
        LinkedHashSet bundles = new LinkedHashSet();
        for (URL url : classpath) {
            File dir = new File(url.toURI());
            bundles.addAll(FileUtils.getFiles((File)dir, (String)(bundle.replace(".", FileUtils.FS) + "*.properties"), null));
        }
        return new ArrayList<File>(bundles);
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public void setAmd(boolean amd) {
        this.amd = amd;
    }
}

