/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.jknack.handlebars.ValueResolver;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public enum JsonNodeValueResolver implements ValueResolver
{
    INSTANCE;


    public Object resolve(Object context, String name) {
        Object value = null;
        if (context instanceof ArrayNode) {
            try {
                value = this.resolve(((ArrayNode)context).get(Integer.parseInt(name)));
            }
            catch (NumberFormatException ex) {
                value = null;
            }
        } else if (context instanceof JsonNode) {
            value = this.resolve(((JsonNode)context).get(name));
        }
        return value == null ? UNRESOLVED : value;
    }

    public Object resolve(Object context) {
        if (context instanceof JsonNode) {
            return this.resolve((JsonNode)context);
        }
        return UNRESOLVED;
    }

    private Object resolve(JsonNode node) {
        if (node instanceof BinaryNode) {
            return ((BinaryNode)node).binaryValue();
        }
        if (node instanceof BooleanNode) {
            return ((BooleanNode)node).booleanValue();
        }
        if (node instanceof NullNode) {
            return null;
        }
        if (node instanceof BigIntegerNode) {
            return ((BigIntegerNode)node).bigIntegerValue();
        }
        if (node instanceof DecimalNode) {
            return ((DecimalNode)node).decimalValue();
        }
        if (node instanceof DoubleNode) {
            return ((DoubleNode)node).doubleValue();
        }
        if (node instanceof IntNode) {
            return ((IntNode)node).intValue();
        }
        if (node instanceof LongNode) {
            return ((LongNode)node).longValue();
        }
        if (node instanceof POJONode) {
            return ((POJONode)node).getPojo();
        }
        if (node instanceof TextNode) {
            return ((TextNode)node).textValue();
        }
        return node;
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        if (context instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)context;
            Iterator fieldNames = node.fieldNames();
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            while (fieldNames.hasNext()) {
                String key = (String)fieldNames.next();
                result.put(key, this.resolve(node, key));
            }
            return result.entrySet();
        }
        return Collections.emptySet();
    }
}

