/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Jackson2Helper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new Jackson2Helper();
    private final ObjectMapper mapper;
    private final Map<String, Class<?>> alias = new HashMap();

    public Jackson2Helper(ObjectMapper objectMapper) {
        this.mapper = (ObjectMapper)Validate.notNull((Object)objectMapper, (String)"The object mapper is required.", (Object[])new Object[0]);
    }

    private Jackson2Helper() {
        this(new ObjectMapper());
    }

    public CharSequence apply(Object context, Options options) throws IOException {
        if (context == null) {
            return (CharSequence)options.hash("default", (Object)"");
        }
        String viewName = (String)options.hash("view", (Object)"");
        JsonGenerator generator = null;
        try {
            Boolean pretty;
            ObjectWriter writer;
            if (!StringUtils.isEmpty((CharSequence)viewName)) {
                Class<?> viewClass = this.alias.get(viewName);
                if (viewClass == null) {
                    viewClass = this.getClass().getClassLoader().loadClass(viewName);
                }
                writer = this.mapper.writerWithView(viewClass);
            } else {
                writer = this.mapper.writer();
            }
            JsonFactory jsonFactory = this.mapper.getFactory();
            SegmentedStringWriter output = new SegmentedStringWriter(jsonFactory._getBufferRecycler());
            generator = jsonFactory.createJsonGenerator((Writer)output);
            Boolean escapeHtml = (Boolean)options.hash("escapeHTML", (Object)Boolean.FALSE);
            if (escapeHtml.booleanValue()) {
                generator.setCharacterEscapes((CharacterEscapes)new HtmlEscapes());
            }
            if ((pretty = (Boolean)options.hash("pretty", (Object)Boolean.FALSE)).booleanValue()) {
                writer.withDefaultPrettyPrinter().writeValue(generator, context);
            } else {
                writer.writeValue(generator, context);
            }
            generator.close();
            Handlebars.SafeString safeString = new Handlebars.SafeString((CharSequence)output.getAndClear());
            return safeString;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(viewName, ex);
        }
        finally {
            if (generator != null && !generator.isClosed()) {
                generator.close();
            }
        }
    }

    public Jackson2Helper viewAlias(String alias, Class<?> viewClass) {
        this.alias.put((String)Validate.notEmpty((CharSequence)alias, (String)"A view alias is required.", (Object[])new Object[0]), (Class<?>)Validate.notNull(viewClass, (String)"A view class is required.", (Object[])new Object[0]));
        return this;
    }

    private static class HtmlEscapes
    extends CharacterEscapes {
        private int[] escapeTable = CharacterEscapes.standardAsciiEscapesForJSON();

        private HtmlEscapes() {
            this.escapeTable[60] = -1;
            this.escapeTable[62] = -1;
            this.escapeTable[38] = -1;
            this.escapeTable[39] = -1;
        }

        public int[] getEscapeCodesForAscii() {
            return this.escapeTable;
        }

        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    }
}

