/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class GuavaCachedTemplateLoader
implements TemplateLoader {
    private final TemplateLoader delegate;
    private final Cache<String, TemplateSource> cache;

    public GuavaCachedTemplateLoader(TemplateLoader delegate, Cache<String, TemplateSource> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    public static GuavaCachedTemplateLoader cacheWithExpiration(TemplateLoader delegate, long duration, TimeUnit unit) {
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(duration, unit).build();
        return new GuavaCachedTemplateLoader(delegate, (Cache<String, TemplateSource>)cache);
    }

    public TemplateSource sourceAt(String location) throws IOException {
        try {
            return (TemplateSource)this.cache.get((Object)location, () -> this.delegate.sourceAt(location));
        }
        catch (ExecutionException e) {
            throw Handlebars.Utils.propagate((Throwable)e.getCause());
        }
    }

    public String resolve(String location) {
        return this.delegate.resolve(location);
    }

    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    public String getSuffix() {
        return this.delegate.getSuffix();
    }

    public void setPrefix(String prefix) {
        this.delegate.setPrefix(prefix);
    }

    public void setSuffix(String suffix) {
        this.delegate.setSuffix(suffix);
    }

    public void setCharset(Charset charset) {
        this.delegate.setCharset(charset);
    }

    public Charset getCharset() {
        return this.delegate.getCharset();
    }
}

