/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.cache;

import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.io.TemplateSource;
import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.Validate;

public class GuavaTemplateCache
implements TemplateCache {
    private final Cache<TemplateSource, Template> cache;

    public GuavaTemplateCache(Cache<TemplateSource, Template> cache) {
        this.cache = (Cache)Validate.notNull(cache, (String)"The cache is required.", (Object[])new Object[0]);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public void evict(TemplateSource source) {
        this.cache.invalidate((Object)source);
    }

    public Template get(final TemplateSource source, final Parser parser) throws IOException {
        Validate.notNull((Object)source, (String)"The source is required.", (Object[])new Object[0]);
        Validate.notNull((Object)parser, (String)"The parser is required.", (Object[])new Object[0]);
        try {
            return (Template)this.cache.get((Object)source, (Callable)new Callable<Template>(){

                @Override
                public Template call() throws IOException {
                    return parser.parse(source);
                }
            });
        }
        catch (ExecutionException ex) {
            throw this.launderThrowable(source, ex.getCause());
        }
    }

    private RuntimeException launderThrowable(TemplateSource source, Throwable cause) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return new HandlebarsException("Can't parse: " + source, cause);
    }
}

