/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Function;

public class CaffeineTemplateLoader
implements TemplateLoader {
    private final TemplateLoader delegate;
    private final Cache<String, TemplateSource> cache;

    public CaffeineTemplateLoader(TemplateLoader delegate, Cache<String, TemplateSource> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    public TemplateSource sourceAt(String location) {
        return (TemplateSource)this.cache.get((Object)location, this.loadTemplate());
    }

    public String resolve(String location) {
        return this.delegate.resolve(location);
    }

    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    public String getSuffix() {
        return this.delegate.getSuffix();
    }

    public void setPrefix(String prefix) {
        this.delegate.setPrefix(prefix);
    }

    public void setSuffix(String suffix) {
        this.delegate.setSuffix(suffix);
    }

    public void setCharset(Charset charset) {
        this.delegate.setCharset(charset);
    }

    public Charset getCharset() {
        return this.delegate.getCharset();
    }

    private Function<String, TemplateSource> loadTemplate() {
        return path -> {
            try {
                return this.delegate.sourceAt(path);
            }
            catch (IOException ex) {
                throw Handlebars.Utils.propagate((Throwable)ex);
            }
        };
    }
}

