/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.executor;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.github.jimu.msg.EventListener;
import org.github.jimu.msg.bean.EventBean;
import org.github.jimu.msg.executor.IPoster;

public class LocalProcessMainThreadPoster
extends Handler
implements IPoster {
    private final List<Pair<EventBean, EventListener<EventBean>>> cache = new ArrayList<Pair<EventBean, EventListener<EventBean>>>();
    private boolean started;
    private static final long threshold = 10L;

    public LocalProcessMainThreadPoster() {
        super(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends EventBean> void postEvent(@NonNull T event, @NonNull EventListener<T> target) {
        List<Pair<EventBean, EventListener<EventBean>>> list = this.cache;
        synchronized (list) {
            Pair pair = new Pair(event, target);
            this.cache.add((Pair<EventBean, EventListener<EventBean>>)pair);
            if (!this.started) {
                this.removeMessages(0);
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        long startStamp = System.currentTimeMillis();
        while (true) {
            long t;
            if ((t = System.currentTimeMillis()) > startStamp + 10L) {
                this.started = false;
                this.resumeLater();
                return;
            }
            List<Pair<EventBean, EventListener<EventBean>>> list = this.cache;
            synchronized (list) {
                if (this.cache.size() > 0) {
                    Pair<EventBean, EventListener<EventBean>> temp = this.cache.remove(0);
                    if (temp.second != null) {
                        ((EventListener)temp.second).onEvent((EventBean)temp.first);
                    }
                } else {
                    this.started = false;
                    this.resumeLater();
                    break;
                }
            }
        }
    }

    private void start() {
        this.sendEmptyMessage(0);
    }

    private void resumeLater() {
        this.sendEmptyMessageDelayed(0, 100L);
    }
}

