/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.core;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import com.luojilab.component.componentlib.log.ILogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteObservableHandler
extends Handler {
    private final Map<String, List<WeakReference<Messenger>>> eventSubscriber = new HashMap<String, List<WeakReference<Messenger>>>();

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        switch (msg.what) {
            case 9999: {
                this.handleSubscribe(msg);
                break;
            }
            case 10000: {
                this.handlePostEvent(msg);
                break;
            }
        }
    }

    private void handleSubscribe(Message msg) {
        Bundle bundle = msg.getData();
        String eventClz = bundle.getString("bundle_str_event_clz");
        if (!this.eventSubscriber.containsKey(eventClz)) {
            ArrayList<WeakReference<Messenger>> subscribes = new ArrayList<WeakReference<Messenger>>();
            WeakReference<Messenger> subscriberRef = new WeakReference<Messenger>(msg.replyTo);
            subscribes.add(subscriberRef);
            this.eventSubscriber.put(eventClz, subscribes);
        } else {
            List<WeakReference<Messenger>> subscribes = this.eventSubscriber.get(eventClz);
            WeakReference<Messenger> subscriberRef = new WeakReference<Messenger>(msg.replyTo);
            subscribes.add(subscriberRef);
        }
    }

    private void handlePostEvent(Message msg) {
        Bundle bundle = msg.getData();
        String eventClz = bundle.getString("bundle_str_event_clz");
        if (TextUtils.isEmpty((CharSequence)eventClz)) {
            ILogger.logger.error("[DD-Compo]", "cannot handle non class event");
            return;
        }
        List<WeakReference<Messenger>> subscribes = this.eventSubscriber.get(eventClz);
        if (subscribes == null) {
            return;
        }
        for (int i = 0; i < subscribes.size(); ++i) {
            WeakReference<Messenger> subscriberRef = subscribes.get(i);
            if (subscriberRef == null || subscriberRef.get() == null) {
                subscribes.remove(i);
                --i;
                continue;
            }
            Messenger messenger = (Messenger)subscriberRef.get();
            Message cm = Message.obtain();
            cm.what = 2;
            cm.setData(msg.getData());
            try {
                messenger.send(cm);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                subscriberRef.clear();
                subscribes.remove(i);
                --i;
            }
        }
    }
}

