/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.bean;

import org.github.jimu.msg.ConsumeOn;
import org.github.jimu.msg.EventListener;
import org.github.jimu.msg.Utils;
import org.github.jimu.msg.bean.EventBean;

public final class ConsumerMeta<T extends EventBean> {
    private ConsumeOn consumeOn;
    private EventListener<T> eventListener;
    private String process;

    public ConsumeOn getConsumeOn() {
        return this.consumeOn;
    }

    public EventListener<T> getEventListener() {
        return this.eventListener;
    }

    public String getProcess() {
        return this.process;
    }

    private ConsumerMeta(Builder<T> builder) {
        this.consumeOn = ((Builder)builder).consumeOn;
        this.eventListener = ((Builder)builder).eventListener;
        this.process = ((Builder)builder).process;
        Utils.checkNotNull(this.eventListener, "eventListener cannot be null,call ConsumerMate.Builder.eventListener before build");
        Utils.checkNotNull(this.process, "process cannot be null, you can use empty string for the default main process");
    }

    public static <T extends EventBean> Builder<T> newBuilder() {
        return new Builder();
    }

    public static final class Builder<T extends EventBean> {
        private ConsumeOn consumeOn = ConsumeOn.Main;
        private EventListener<T> eventListener;
        private String process = "";

        private Builder() {
        }

        public Builder<T> consumeOn(ConsumeOn val) {
            this.consumeOn = val;
            return this;
        }

        public Builder<T> process(String val) {
            this.process = val;
            return this;
        }

        public Builder<T> currentProcess() {
            this.process = Utils.getProcessName();
            return this;
        }

        public Builder<T> eventListener(EventListener<T> val) {
            this.eventListener = val;
            return this;
        }

        public ConsumerMeta<T> build() {
            return new ConsumerMeta(this);
        }
    }
}

