/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg;

import android.app.Application;
import android.os.Messenger;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.luojilab.component.componentlib.log.ILogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.github.jimu.msg.AriseAt;
import org.github.jimu.msg.ConsumeOn;
import org.github.jimu.msg.EventListener;
import org.github.jimu.msg.Utils;
import org.github.jimu.msg.bean.EventBean;
import org.github.jimu.msg.bean.ManagerMethod;
import org.github.jimu.msg.bean.RemoteEventBean;
import org.github.jimu.msg.bean.State;
import org.github.jimu.msg.core.CrossSubscriberHandler;
import org.github.jimu.msg.core.MessageBridgeService;
import org.github.jimu.msg.core.Secy;
import org.github.jimu.msg.executor.CrossProcessPoster;
import org.github.jimu.msg.executor.LocalProcessBackgroundPoster;
import org.github.jimu.msg.executor.LocalProcessMainThreadPoster;
import osp.leobert.android.reportprinter.notation.ChangeLog;

public final class EventManager {
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private static final Map<String, Class<? extends MessageBridgeService>> processMsgBridgeServiceMapper = new HashMap<String, Class<? extends MessageBridgeService>>();
    private ThreadLocal<State> stateThreadLocal = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State();
        }
    };
    private ThreadLocal<State> stateThreadLocal2 = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State();
        }
    };
    private CrossProcessPoster crossProcessPoster = new CrossProcessPoster();
    private static volatile EventManager instance;
    private Secy secy;

    public static void appendMapper(@NonNull String s, @NonNull Class<? extends MessageBridgeService> serviceClz) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            processMsgBridgeServiceMapper.put(s, serviceClz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Application application) {
        if (instance == null) {
            Class<EventManager> clazz = EventManager.class;
            synchronized (EventManager.class) {
                if (instance == null) {
                    instance = new EventManager(application);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            ILogger.logger.monitor("EventManager has been initialized previous");
        }
    }

    private EventManager(Application application) {
        this.secy = new Secy(application, new LocalProcessMainThreadPoster(), new LocalProcessBackgroundPoster(DEFAULT_EXECUTOR_SERVICE), this.crossProcessPoster, processMsgBridgeServiceMapper);
    }

    public static EventManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("you must call init(Application app) at first");
        }
        return instance;
    }

    public <T extends EventBean> void subscribe(@NonNull Class<T> eventClz, @NonNull EventListener<T> listener) {
        this.subscribe(eventClz, AriseAt.local(), listener);
    }

    public <T extends EventBean> void subscribe(@NonNull Class<T> eventClz, @NonNull AriseAt eventType, @NonNull EventListener<T> listener) {
        this.subscribe(eventClz, eventType, ConsumeOn.Main, listener);
    }

    public <T extends EventBean> void subscribe(@NonNull Class<T> eventClz, @NonNull AriseAt eventType, @NonNull ConsumeOn consumeOn, @NonNull EventListener<T> listener) {
        ILogger.logger.monitor(">>> subscribe " + eventClz + "\rcurrentProcess:" + Utils.getProcessName() + "\rconsume on:" + (Object)((Object)consumeOn));
        eventType.log();
        this.secy.subscribe(eventClz, eventType, consumeOn, listener);
    }

    public <T extends EventBean> void unsubscribe(@NonNull EventListener<T> listener) {
        this.secy.unsubscribe(listener);
    }

    public <T extends EventBean> void postEvent(@NonNull T event) {
        if (event == null) {
            ILogger.logger.monitor("cannot post null");
            return;
        }
        this.secy.postNormalEventOnLocalProcess(this.stateThreadLocal.get(), event);
        if (event instanceof RemoteEventBean) {
            RemoteEventBean remoteEventBean = (RemoteEventBean)event;
            this.secy.postNormalEventToRemoteProcess(this.stateThreadLocal2.get(), remoteEventBean);
        }
    }

    public void updateMessenger(String processName, Messenger currentProcessMessenger) {
        ILogger.logger.monitor("eventManager updateMessenger :" + processName + "; check:" + Utils.getProcessName() + ";em:" + EventManager.getInstance().toString() + ";poster:" + this.crossProcessPoster.toString());
        this.crossProcessPoster.setRemoteMessenger(currentProcessMessenger);
    }

    public void fastHandleLocalProcessEvent(CrossSubscriberHandler handler, RemoteEventBean event, Class clz) {
        handler.onFastHandleLocalProcessEvent(this.secy, this.stateThreadLocal.get(), event, clz);
    }

    @ChangeLog(version="1.3.3", changes={"add static factory to create proxy for manager api"})
    public static <T> T create(Class<T> service) {
        Utils.validateCompoEventManagerInterface(service);
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                ManagerMethod.parse(method).invoke(args);
                return null;
            }
        });
    }
}

