/*
 * Decompiled with CFR 0.152.
 */
package com.luojilab.component.componentlib.utils;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.luojilab.router.facade.enums.Type;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class UriUtils {
    public static HashMap<String, String> parseParams(Uri uri) {
        if (uri == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> temp = new HashMap<String, String>();
        Set<String> keys = UriUtils.getQueryParameterNames(uri);
        for (String key : keys) {
            temp.put(key, uri.getQueryParameter(key));
        }
        return temp;
    }

    public static Set<String> getQueryParameterNames(Uri uri) {
        int end;
        String query = uri.getEncodedQuery();
        if (query == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = query.substring(start, separator);
            try {
                names.add(URLDecoder.decode(name, "UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while ((start = end + 1) < query.length());
        return Collections.unmodifiableSet(names);
    }

    public static int parseInt(String src) {
        return UriUtils.parseInt(src, 0);
    }

    public static int parseInt(String src, int defaultValue) {
        if (TextUtils.isEmpty((CharSequence)src)) {
            return defaultValue;
        }
        int index = src.indexOf(".");
        if (index > 0) {
            src = src.substring(0, index);
        }
        try {
            return Integer.parseInt(src);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void setBundleValue(Bundle bundle, Map<String, String> params, Map<String, Integer> paramsType) {
        if (paramsType != null && params != null && !paramsType.isEmpty() && !params.isEmpty()) {
            for (Map.Entry<String, Integer> param : paramsType.entrySet()) {
                UriUtils.setBundleValue(bundle, param.getValue(), param.getKey(), params.get(param.getKey()));
            }
        }
    }

    public static void setBundleValue(Bundle bundle, Integer typeDef, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        try {
            if (null != typeDef) {
                if (typeDef.intValue() == Type.BOOLEAN.ordinal()) {
                    bundle.putBoolean(key, Boolean.parseBoolean(value));
                } else if (typeDef.intValue() == Type.BYTE.ordinal()) {
                    bundle.putByte(key, Byte.valueOf(value).byteValue());
                } else if (typeDef.intValue() == Type.SHORT.ordinal()) {
                    bundle.putShort(key, Short.valueOf(value).shortValue());
                } else if (typeDef.intValue() == Type.INT.ordinal()) {
                    bundle.putInt(key, Integer.valueOf(value).intValue());
                } else if (typeDef.intValue() == Type.LONG.ordinal()) {
                    bundle.putLong(key, Long.valueOf(value).longValue());
                } else if (typeDef.intValue() == Type.FLOAT.ordinal()) {
                    bundle.putFloat(key, Float.valueOf(value).floatValue());
                } else if (typeDef.intValue() == Type.DOUBLE.ordinal()) {
                    bundle.putDouble(key, Double.valueOf(value).doubleValue());
                } else if (typeDef.intValue() == Type.STRING.ordinal()) {
                    bundle.putString(key, value);
                } else if (typeDef.intValue() != Type.PARCELABLE.ordinal()) {
                    if (typeDef.intValue() == Type.OBJECT.ordinal()) {
                        bundle.putString(key, value);
                    } else {
                        bundle.putString(key, value);
                    }
                }
            } else {
                bundle.putString(key, value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String toSafeString(Uri uri) {
        if (uri == null) {
            return "null uri";
        }
        String scheme = uri.getScheme();
        String ssp = uri.getSchemeSpecificPart();
        if (scheme != null) {
            if (scheme.equalsIgnoreCase("tel") || scheme.equalsIgnoreCase("sip") || scheme.equalsIgnoreCase("sms") || scheme.equalsIgnoreCase("smsto") || scheme.equalsIgnoreCase("mailto")) {
                StringBuilder builder = new StringBuilder(64);
                builder.append(scheme);
                builder.append(':');
                if (ssp != null) {
                    for (int i = 0; i < ssp.length(); ++i) {
                        char c = ssp.charAt(i);
                        if (c == '-' || c == '@' || c == '.') {
                            builder.append(c);
                            continue;
                        }
                        builder.append('x');
                    }
                }
                return builder.toString();
            }
            if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("ftp")) {
                ssp = "//" + (uri.getHost() != null ? uri.getHost() : "") + (uri.getPort() != -1 ? ":" + uri.getPort() : "") + "/...";
            }
        }
        StringBuilder builder = new StringBuilder(64);
        if (scheme != null) {
            builder.append(scheme);
            builder.append(':');
        }
        if (ssp != null) {
            builder.append(ssp);
        }
        return builder.toString();
    }
}

