/*
 * Decompiled with CFR 0.152.
 */
package com.luojilab.component.componentlib.router.ui;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.luojilab.component.componentlib.exceptions.UiRouterException;
import com.luojilab.component.componentlib.log.ILogger;
import com.luojilab.component.componentlib.log.impl.DefaultLogger;
import com.luojilab.component.componentlib.router.ui.IComponentRouter;
import com.luojilab.component.componentlib.router.ui.IUIRouter;
import com.luojilab.component.componentlib.router.ui.VerifyResult;
import com.luojilab.component.componentlib.utils.UriUtils;
import com.luojilab.router.facade.utils.RouteUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UIRouter
implements IUIRouter {
    private static ILogger logger = new DefaultLogger("[DdCompo-UiRouter]");
    private static Map<String, IComponentRouter> routerInstanceCache = new HashMap<String, IComponentRouter>();
    private List<IComponentRouter> uiRouters = new ArrayList<IComponentRouter>();
    private HashMap<IComponentRouter, Integer> priorities = new HashMap();
    private static volatile UIRouter instance;

    public static void showLog(boolean isShowLog) {
        logger.showLog(isShowLog);
    }

    public static void showStackTrace(boolean isShowStackTrace) {
        logger.showStackTrace(isShowStackTrace);
    }

    public static void showMonitor(boolean isShowMonitor) {
        logger.showMonitor(isShowMonitor);
    }

    public static void enableDebug() {
        UIRouter.showLog(true);
        UIRouter.showMonitor(true);
        UIRouter.showStackTrace(true);
    }

    public static ILogger getLogger() {
        return logger;
    }

    private UIRouter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIRouter getInstance() {
        if (instance != null) return instance;
        Class<UIRouter> clazz = UIRouter.class;
        synchronized (UIRouter.class) {
            if (instance != null) return instance;
            instance = new UIRouter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void registerUI(IComponentRouter router, int priority) {
        IComponentRouter temp;
        Integer tp;
        if (this.priorities.containsKey(router) && priority == this.priorities.get(router)) {
            return;
        }
        this.removeOldUIRouter(router);
        int i = 0;
        Iterator<IComponentRouter> iterator = this.uiRouters.iterator();
        while (iterator.hasNext() && (tp = this.priorities.get(temp = iterator.next())) != null && tp > priority) {
            ++i;
        }
        this.uiRouters.add(i, router);
        this.priorities.put(router, priority);
    }

    @Override
    public void registerUI(IComponentRouter router) {
        this.registerUI(router, 0);
    }

    @Override
    public void registerUI(String host) {
        IComponentRouter router = this.fetch(host);
        if (router != null) {
            this.registerUI(router, 0);
        }
    }

    @Override
    public void registerUI(String host, int priority) {
        IComponentRouter router = this.fetch(host);
        if (router != null) {
            this.registerUI(router, priority);
        }
    }

    @Override
    public void unregisterUI(IComponentRouter router) {
        for (int i = 0; i < this.uiRouters.size(); ++i) {
            if (router != this.uiRouters.get(i)) continue;
            this.uiRouters.remove(i);
            this.priorities.remove(router);
            break;
        }
    }

    @Override
    public void unregisterUI(String host) {
        IComponentRouter router = this.fetch(host);
        if (router != null) {
            this.unregisterUI(router);
        }
    }

    @Override
    public boolean openUri(Context context, String url, Bundle bundle) {
        return this.openUri(context, url, bundle, (Integer)0);
    }

    @Override
    public boolean openUri(Context context, Uri uri, Bundle bundle) {
        return this.openUri(context, uri, bundle, (Integer)0);
    }

    @Override
    public boolean openUri(Context context, String url, Bundle bundle, Integer requestCode) {
        if (!TextUtils.isEmpty((CharSequence)(url = url.trim()))) {
            if (!(url.contains("://") || url.startsWith("tel:") && url.startsWith("smsto:") && url.startsWith("file:"))) {
                url = "http://" + url;
            }
            Uri uri = Uri.parse((String)url);
            return this.openUri(context, uri, bundle, requestCode, null);
        }
        return true;
    }

    @Override
    public boolean openUri(Context context, Uri uri, Bundle bundle, Integer requestCode) {
        for (IComponentRouter temp : this.uiRouters) {
            try {
                VerifyResult verifyResult = temp.verifyUri(uri, bundle, false);
                if (!verifyResult.isSuccess() || !temp.openUri(context, uri, bundle, requestCode, null)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean openUri(Context context, String url, Bundle bundle, List<IComponentRouter.IntentDecor> intentDecors) {
        return this.openUri(context, url, bundle, (Integer)0, intentDecors);
    }

    @Override
    public boolean openUri(Context context, Uri uri, Bundle bundle, List<IComponentRouter.IntentDecor> intentDecors) {
        return this.openUri(context, uri, bundle, (Integer)0, intentDecors);
    }

    @Override
    public boolean openUri(Context context, String url, Bundle bundle, Integer requestCode, List<IComponentRouter.IntentDecor> intentDecors) {
        if (!TextUtils.isEmpty((CharSequence)(url = url.trim()))) {
            if (!(url.contains("://") || url.startsWith("tel:") && url.startsWith("smsto:") && url.startsWith("file:"))) {
                url = "http://" + url;
            }
            Uri uri = Uri.parse((String)url);
            return this.openUri(context, uri, bundle, requestCode, intentDecors);
        }
        return true;
    }

    @Override
    public boolean openUri(Context context, Uri uri, Bundle bundle, Integer requestCode, List<IComponentRouter.IntentDecor> intentDecors) {
        for (IComponentRouter temp : this.uiRouters) {
            try {
                VerifyResult verifyResult = temp.verifyUri(uri, bundle, false);
                if (!verifyResult.isSuccess() || !temp.openUri(context, uri, bundle, requestCode, intentDecors)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean verifyUri(Uri uri) {
        for (IComponentRouter temp : this.uiRouters) {
            if (!temp.verifyUri(uri)) continue;
            return true;
        }
        UIRouter.getLogger().monitor("cannot verify uri for: " + UriUtils.toSafeString(uri) + ";\r cannot navigate to the target");
        return false;
    }

    @Override
    @NonNull
    public VerifyResult verifyUri(Uri uri, Bundle bundle, boolean checkParams) {
        StringBuilder verifyMsg = new StringBuilder();
        for (IComponentRouter temp : this.uiRouters) {
            VerifyResult result = temp.verifyUri(uri, bundle, checkParams);
            if (result.isSuccess()) {
                return result;
            }
            if (result.getThrowable() == null) continue;
            verifyMsg.append(result.getThrowable().getMessage()).append("\r");
        }
        String msg = "cannot verify uri for: " + UriUtils.toSafeString(uri) + ";\r cannot navigate to the target\r" + verifyMsg.toString() + "check if uri error\uff0cparams error or component has not been mounted";
        UIRouter.getLogger().monitor(msg);
        return new VerifyResult(false, new UiRouterException(msg){});
    }

    private void removeOldUIRouter(IComponentRouter router) {
        Iterator<IComponentRouter> iterator = this.uiRouters.iterator();
        while (iterator.hasNext()) {
            IComponentRouter tmp = iterator.next();
            if (tmp != router) continue;
            iterator.remove();
            this.priorities.remove(tmp);
            UIRouter.getLogger().monitor("remove OldUIRouter success");
        }
    }

    private IComponentRouter fetch(@NonNull String host) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            UIRouter.getLogger().monitor("Try to fetch ComponentRouter for null/empty host. Ignore!");
            return null;
        }
        String path = RouteUtils.genHostUIRouterClass((String)host);
        if (routerInstanceCache.containsKey(path)) {
            return routerInstanceCache.get(path);
        }
        try {
            Class<?> cla = Class.forName(path);
            IComponentRouter instance = (IComponentRouter)cla.newInstance();
            routerInstanceCache.put(path, instance);
            return instance;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

