/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a!\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007H\u0000\u001a+\u0010\b\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007\u001a#\u0010\u0002\u001a\u00020\u0006*\u00020\u00012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007\u001a+\u0010\u000b\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007\u001a\u001c\u0010\f\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\f\u001a\u00020\n*\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\f\u001a\u00020\n*\u00020\u0001\u001a\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\u0013"}, d2={"xContentBuilder", "Lorg/elasticsearch/common/xcontent/XContentBuilder;", "obj", "", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "arrField", "name", "", "objField", "stringify", "Lorg/elasticsearch/common/xcontent/ToXContent;", "out", "Ljava/io/OutputStream;", "pretty", "", "writeAny", "es-kotlin-client"})
public final class KotlinExtensionsKt {
    @NotNull
    public static final String stringify(@NotNull ToXContent $this$stringify, boolean pretty) {
        Intrinsics.checkNotNullParameter((Object)$this$stringify, (String)"<this>");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)bos);
        if (pretty) {
            builder.prettyPrint();
        }
        $this$stringify.toXContent(builder, ToXContent.EMPTY_PARAMS);
        builder.close();
        bos.flush();
        bos.close();
        byte[] byArray = bos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bos.toByteArray()");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl = false;
        boolean bl2 = false;
        return new String(byArray, charset);
    }

    public static /* synthetic */ String stringify$default(ToXContent toXContent, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return KotlinExtensionsKt.stringify(toXContent, bl);
    }

    public static final void stringify(@NotNull ToXContent $this$stringify, @NotNull OutputStream out, boolean pretty) {
        Intrinsics.checkNotNullParameter((Object)$this$stringify, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)out);
        if (pretty) {
            builder.prettyPrint();
        }
        $this$stringify.toXContent(builder, ToXContent.EMPTY_PARAMS);
        builder.close();
    }

    public static /* synthetic */ void stringify$default(ToXContent toXContent, OutputStream outputStream, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        KotlinExtensionsKt.stringify(toXContent, outputStream, bl);
    }

    @NotNull
    public static final String stringify(@NotNull XContentBuilder $this$stringify) {
        Intrinsics.checkNotNullParameter((Object)$this$stringify, (String)"<this>");
        if ($this$stringify.getOutputStream() instanceof ByteArrayOutputStream) {
            $this$stringify.flush();
            $this$stringify.getOutputStream().flush();
            Object object = $this$stringify.getOutputStream();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.io.ByteArrayOutputStream");
            }
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this.outputStream as Byt\u2026tputStream).toByteArray()");
            object = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UTF_8");
            boolean bl = false;
            boolean bl2 = false;
            return new String(byArray, (Charset)object);
        }
        throw new IllegalStateException("Cannot grab content from underlying OutputStream because it is not a ByteArrayOutputStream");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void writeAny(@NotNull XContentBuilder $this$writeAny, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAny, (String)"<this>");
        if (obj == null) {
            $this$writeAny.nullValue();
            return;
        } else {
            Object object = obj;
            if (object instanceof XContentBuilder) {
                if (!(((XContentBuilder)obj).getOutputStream() instanceof ByteArrayOutputStream)) throw new IllegalStateException("Cannot grab content from underlying OutputStream because it is not a ByteArrayOutputStream");
                ((XContentBuilder)obj).flush();
                ((XContentBuilder)obj).getOutputStream().flush();
                OutputStream outputStream = ((XContentBuilder)obj).getOutputStream();
                if (outputStream == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.io.ByteArrayOutputStream");
                }
                byte[] byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"obj.outputStream as Byte\u2026tputStream).toByteArray()");
                boolean bl = false;
                $this$writeAny.rawValue((InputStream)new ByteArrayInputStream(byArray), XContentType.JSON);
                return;
            } else if (object instanceof Instant) {
                $this$writeAny.value(((Instant)obj).toString());
                return;
            } else if (object instanceof Number) {
                $this$writeAny.value(obj);
                return;
            } else if (object instanceof String) {
                $this$writeAny.value((String)obj);
                return;
            } else if (object instanceof Boolean) {
                $this$writeAny.value(((Boolean)obj).booleanValue());
                return;
            } else if (object instanceof Map) {
                $this$writeAny.startObject();
                Iterable $this$forEach$iv = ((Map)obj).entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry $dstr$k$v = (Map.Entry)element$iv;
                    boolean bl = false;
                    Map.Entry entry = $dstr$k$v;
                    boolean bl2 = false;
                    Object k = entry.getKey();
                    Map.Entry entry2 = $dstr$k$v;
                    boolean bl3 = false;
                    Object v = entry2.getValue();
                    $this$writeAny.field(String.valueOf(k));
                    KotlinExtensionsKt.writeAny($this$writeAny, v);
                }
                $this$writeAny.endObject();
                return;
            } else if (object instanceof Object[]) {
                $this$writeAny.startArray();
                Object[] $this$forEach$iv = (Object[])obj;
                boolean $i$f$forEach = false;
                Object[] objectArray = $this$forEach$iv;
                int element$iv = objectArray.length;
                for (int $dstr$k$v = 0; $dstr$k$v < element$iv; ++$dstr$k$v) {
                    Object element$iv2;
                    Object it = element$iv2 = objectArray[$dstr$k$v];
                    boolean bl = false;
                    KotlinExtensionsKt.writeAny($this$writeAny, it);
                }
                $this$writeAny.endArray();
                return;
            } else if (object instanceof Iterable) {
                $this$writeAny.startArray();
                Iterable $this$forEach$iv = (Iterable)obj;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl = false;
                    KotlinExtensionsKt.writeAny($this$writeAny, it);
                }
                $this$writeAny.endArray();
                return;
            } else if (object instanceof Enum) {
                $this$writeAny.value(((Enum)obj).name());
                return;
            } else {
                if (!(object instanceof KProperty)) throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported type: ", (Object)Reflection.getOrCreateKotlinClass(obj.getClass())));
                $this$writeAny.value(((KProperty)obj).getName());
            }
        }
    }

    public static final void obj(@NotNull XContentBuilder $this$obj, @NotNull Function1<? super XContentBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$obj, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$obj.startObject();
        block.invoke((Object)$this$obj);
        $this$obj.endObject();
    }

    public static final void objField(@NotNull XContentBuilder $this$objField, @NotNull String name, @NotNull Function1<? super XContentBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$objField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$objField.startObject(name);
        block.invoke((Object)$this$objField);
        $this$objField.endObject();
    }

    public static final void arrField(@NotNull XContentBuilder $this$arrField, @NotNull String name, @NotNull Function1<? super XContentBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$arrField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$arrField.startArray(name);
        block.invoke((Object)$this$arrField);
        $this$arrField.endArray();
    }

    @NotNull
    public static final XContentBuilder xContentBuilder(@NotNull Function1<? super XContentBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        XContentBuilder builder = JsonXContent.contentBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        block.invoke((Object)builder);
        return builder;
    }

    @NotNull
    public static final XContentBuilder xContentBuilder(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return KotlinExtensionsKt.xContentBuilder((Function1<? super XContentBuilder, Unit>)((Function1)new Function1<XContentBuilder, Unit>(obj){
            final /* synthetic */ Object $obj;
            {
                this.$obj = $obj;
                super(1);
            }

            public final void invoke(@NotNull XContentBuilder $this$xContentBuilder) {
                Intrinsics.checkNotNullParameter((Object)$this$xContentBuilder, (String)"$this$xContentBuilder");
                KotlinExtensionsKt.writeAny($this$xContentBuilder, this.$obj);
            }
        }));
    }
}

