/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Checkable;
import android.widget.LinearLayout;
import com.serenegiant.widget.Touchable;

public class CheckableLinearLayout
extends LinearLayout
implements Checkable,
Touchable {
    private boolean mChecked;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private float mTouchX;
    private float mTouchY;

    public CheckableLinearLayout(Context context) {
        this(context, null);
    }

    public CheckableLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CheckableLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getChildAt(i);
                if (!(v instanceof Checkable)) continue;
                ((Checkable)v).setChecked(checked);
            }
            this.refreshDrawableState();
        }
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckableLinearLayout.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mTouchX = ev.getX();
        this.mTouchY = ev.getY();
        return super.onInterceptTouchEvent(ev);
    }

    @Override
    public float touchX() {
        return this.mTouchX;
    }

    @Override
    public float touchY() {
        return this.mTouchY;
    }
}

