/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollectionMap<K, V>
implements Map<K, Collection<V>> {
    private final Map<K, Collection<V>> contents = this.createContentsMap();

    protected Map<K, Collection<V>> createContentsMap() {
        return new HashMap();
    }

    protected Collection<V> createCollection() {
        return new ArrayList();
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contents.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    public boolean containsInValue(V value) {
        for (Collection<V> collection : this.contents.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.contents.entrySet();
    }

    @Override
    public Collection<V> get(Object key) {
        return this.contents.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        return this.contents.keySet();
    }

    @Override
    public Collection<V> put(K key, Collection<V> value) {
        return this.contents.put(key, value);
    }

    public boolean add(K key, V value) {
        Collection<V> collection = this.contents.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.contents.put(key, collection);
        }
        return collection.add(value);
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends Collection<V>> m) {
        this.contents.putAll(m);
    }

    public void addAll(Map<? extends K, ? extends Collection<V>> m) {
        for (Map.Entry<K, Collection<V>> entry : m.entrySet()) {
            this.addAll(entry.getKey(), entry.getValue());
        }
    }

    public boolean addAll(K key, Collection<? extends V> values) {
        Collection<V> collection = this.contents.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.contents.put(key, collection);
        }
        return collection.addAll(values);
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.contents.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Collection<V> collection = this.contents.get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    public int size(K key) {
        Collection<V> collection = this.contents.containsKey(key) ? this.contents.get(key) : null;
        return collection != null ? collection.size() : 0;
    }

    @Override
    @NonNull
    public Collection<Collection<V>> values() {
        return this.contents.values();
    }

    public Collection<V> valuesAll() {
        Collection<V> result = this.createCollection();
        for (Collection<V> v : this.values()) {
            result.addAll(v);
        }
        return result;
    }
}

