/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.service;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.serenegiant.common.R;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.HandlerThreadHandler;
import java.util.List;

public abstract class BaseService
extends Service {
    private static final boolean DEBUG = false;
    private static final String TAG = BaseService.class.getSimpleName();
    private static final int NOTIFICATION_ID = R.string.service_name;
    protected final Object mSync = new Object();
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private Handler mAsyncHandler;
    private LocalBroadcastManager mLocalBroadcastManager;
    private volatile boolean mDestroyed;
    private final BroadcastReceiver mLocalBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                BaseService.this.onReceiveLocalBroadcast(context, intent);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate() {
        super.onCreate();
        Context app_context = this.getApplicationContext();
        Object object = this.mSync;
        synchronized (object) {
            this.mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)this.getApplicationContext());
            IntentFilter filter = this.createIntentFilter();
            if (filter != null && filter.countActions() > 0) {
                this.mLocalBroadcastManager.registerReceiver(this.mLocalBroadcastReceiver, filter);
            }
            if (this.mAsyncHandler == null) {
                this.mAsyncHandler = HandlerThreadHandler.createHandler(((Object)((Object)this)).getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        this.mDestroyed = true;
        Object object = this.mSync;
        synchronized (object) {
            this.mUIHandler.removeCallbacksAndMessages(null);
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacksAndMessages(null);
                try {
                    this.mAsyncHandler.getLooper().quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mAsyncHandler = null;
            }
            if (this.mLocalBroadcastManager != null) {
                try {
                    this.mLocalBroadcastManager.unregisterReceiver(this.mLocalBroadcastReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mLocalBroadcastManager = null;
            }
        }
        super.onDestroy();
    }

    protected boolean isDestroyed() {
        return this.mDestroyed;
    }

    protected abstract IntentFilter createIntentFilter();

    protected abstract void onReceiveLocalBroadcast(Context var1, Intent var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendLocalBroadcast(Intent intent) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mLocalBroadcastManager != null) {
                this.mLocalBroadcastManager.sendBroadcast(intent);
            }
        }
    }

    protected void showNotification(@DrawableRes int smallIconId, @NonNull CharSequence title, @NonNull CharSequence content, PendingIntent intent) {
        this.showNotification(NOTIFICATION_ID, this.getString(R.string.service_name), null, null, smallIconId, R.drawable.ic_notification, title, content, true, intent);
    }

    protected void showNotification(@DrawableRes int smallIconId, @NonNull CharSequence title, @NonNull CharSequence content, boolean isForegroundService, PendingIntent intent) {
        this.showNotification(NOTIFICATION_ID, this.getString(R.string.service_name), null, null, smallIconId, R.drawable.ic_notification, title, content, isForegroundService, intent);
    }

    protected void showNotification(int notificationId, @NonNull String channelId, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content, PendingIntent intent) {
        this.showNotification(notificationId, channelId, null, null, smallIconId, largeIconId, title, content, true, intent);
    }

    protected void showNotification(int notificationId, @NonNull String channelId, @Nullable String groupId, @Nullable String groupName, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content, PendingIntent intent) {
        this.showNotification(notificationId, channelId, groupId, groupName, smallIconId, largeIconId, title, content, true, intent);
    }

    protected void showNotification(int notificationId, @NonNull String channelId, @Nullable String groupId, @Nullable String groupName, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content, final boolean isForegroundService, final PendingIntent intent) {
        this.showNotification(notificationId, title, content, new NotificationFactory(channelId, channelId, 0, groupId, groupName, smallIconId, largeIconId){

            @Override
            protected boolean isForegroundService() {
                return isForegroundService;
            }

            @Override
            protected PendingIntent createContentIntent() {
                return intent;
            }
        });
    }

    protected void showNotification(int notificationId, @NonNull CharSequence title, @NonNull CharSequence content, @NonNull NotificationFactory factory) {
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        Notification notification = factory.createNotification((Context)this, content, title);
        if (factory.isForegroundService()) {
            this.startForeground(notificationId, notification);
        }
        manager.notify(notificationId, notification);
    }

    protected void releaseNotification() {
        this.releaseNotification(NOTIFICATION_ID, this.getString(R.string.service_name), R.drawable.ic_notification, R.drawable.ic_notification, this.getString(R.string.service_name), this.getString(R.string.service_stop));
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotification(int notificationId, @NonNull String channelId, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content) {
        this.showNotification(notificationId, channelId, smallIconId, largeIconId, title, content, null);
        this.releaseNotification(notificationId, channelId);
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotification(int notificationId, @NonNull String channelId) {
        this.stopForeground(true);
        this.cancelNotification(notificationId, channelId);
    }

    @SuppressLint(value={"NewApi"})
    protected void cancelNotification(int notificationId, @Nullable String channelId) {
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        manager.cancel(notificationId);
        this.releaseNotificationChannel(channelId);
    }

    @SuppressLint(value={"NewApi"})
    protected void cancelNotification(int notificationId) {
        this.cancelNotification(notificationId, null);
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotificationChannel(@Nullable String channelId) {
        if (!TextUtils.isEmpty((CharSequence)channelId) && BuildCheck.isOreo()) {
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            try {
                manager.deleteNotificationChannel(channelId);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotificationGroup(@NonNull String groupId) {
        if (!TextUtils.isEmpty((CharSequence)groupId) && BuildCheck.isOreo()) {
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            try {
                manager.deleteNotificationChannelGroup(groupId);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected abstract PendingIntent contextIntent();

    protected void runOnUiThread(Runnable task) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mUIHandler.removeCallbacks(task);
        this.mUIHandler.post(task);
    }

    protected void runOnUiThread(@Nullable Runnable task, long delay) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mUIHandler.removeCallbacks(task);
        if (delay > 0L) {
            this.mUIHandler.postDelayed(task, delay);
        } else {
            this.mUIHandler.post(task);
        }
    }

    protected void removeFromUiThread(@Nullable Runnable task) {
        this.mUIHandler.removeCallbacks(task);
    }

    protected void removeFromUiThreadAll(@Nullable Object token) {
        this.mUIHandler.removeCallbacksAndMessages(token);
    }

    protected void queueEvent(@Nullable Runnable task) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.queueEvent(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueEvent(@Nullable Runnable task, long delay) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacks(task);
                if (delay > 0L) {
                    this.mAsyncHandler.postDelayed(task, delay);
                } else {
                    this.mAsyncHandler.post(task);
                }
            } else {
                throw new IllegalStateException("worker thread is not ready");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEvent(@Nullable Runnable task) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacks(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEventAll(@Nullable Object token) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacksAndMessages(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Handler getAsyncHandler() throws IllegalStateException {
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        Object object = this.mSync;
        synchronized (object) {
            return this.mAsyncHandler;
        }
    }

    public static abstract class NotificationFactory {
        protected final String channelId;
        protected final String channelTitle;
        protected final int importance;
        protected final String groupId;
        protected final String groupName;
        @DrawableRes
        protected final int smallIconId;
        @DrawableRes
        protected final int largeIconId;

        @SuppressLint(value={"InlinedApi"})
        public NotificationFactory(@NonNull String channelId, @Nullable String channelTitle, @DrawableRes int smallIconId) {
            this(channelId, channelId, BuildCheck.isAndroid7() ? 0 : 0, null, null, smallIconId, R.drawable.ic_notification);
        }

        @SuppressLint(value={"InlinedApi"})
        public NotificationFactory(@NonNull String channelId, @Nullable String channelTitle, @DrawableRes int smallIconId, @DrawableRes int largeIconId) {
            this(channelId, channelId, BuildCheck.isAndroid7() ? 0 : 0, null, null, smallIconId, largeIconId);
        }

        public NotificationFactory(@NonNull String channelId, @Nullable String channelTitle, int importance, @Nullable String groupId, @Nullable String groupName, @DrawableRes int smallIconId, @DrawableRes int largeIconId) {
            this.channelId = channelId;
            this.channelTitle = TextUtils.isEmpty((CharSequence)channelTitle) ? channelId : channelTitle;
            this.importance = importance;
            this.groupId = groupId;
            this.groupName = TextUtils.isEmpty((CharSequence)groupName) ? groupId : groupName;
            this.smallIconId = smallIconId;
            this.largeIconId = largeIconId;
        }

        @SuppressLint(value={"NewApi"})
        protected Notification createNotification(Context context, @NonNull CharSequence title, @NonNull CharSequence content) {
            if (BuildCheck.isOreo()) {
                this.createNotificationChannel(context);
            }
            NotificationCompat.Builder builder = this.createNotificationBuilder(context, title, content);
            return builder.build();
        }

        @TargetApi(value=26)
        protected void createNotificationChannel(@NonNull Context context) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            if (manager.getNotificationChannel(this.channelId) == null) {
                NotificationChannel channel = new NotificationChannel(this.channelId, (CharSequence)this.channelTitle, this.importance);
                if (!TextUtils.isEmpty((CharSequence)this.groupId)) {
                    this.createNotificationChannelGroup(context, this.groupId, this.groupName);
                    channel.setGroup(this.groupId);
                }
                channel.setLockscreenVisibility(0);
                manager.createNotificationChannel(this.setupNotificationChannel(channel));
            }
        }

        @NonNull
        protected NotificationChannel setupNotificationChannel(@NonNull NotificationChannel channel) {
            return channel;
        }

        @TargetApi(value=26)
        protected void createNotificationChannelGroup(@NonNull Context context, @Nullable String groupId, @Nullable String groupName) {
            if (!TextUtils.isEmpty((CharSequence)groupId)) {
                NotificationManager manager = (NotificationManager)context.getSystemService("notification");
                List groups = manager.getNotificationChannelGroups();
                NotificationChannelGroup found = null;
                for (NotificationChannelGroup group : groups) {
                    if (!groupId.equals(group.getId())) continue;
                    found = group;
                    break;
                }
                if (found == null) {
                    found = new NotificationChannelGroup(groupId, (CharSequence)(TextUtils.isEmpty((CharSequence)groupName) ? groupId : groupName));
                    manager.createNotificationChannelGroup(this.setupNotificationChannelGroup(found));
                }
            }
        }

        @NonNull
        protected NotificationChannelGroup setupNotificationChannelGroup(@NonNull NotificationChannelGroup group) {
            return group;
        }

        @SuppressLint(value={"InlinedApi"})
        protected NotificationCompat.Builder createNotificationBuilder(@NonNull Context context, @NonNull CharSequence title, @NonNull CharSequence content) {
            PendingIntent deleteIntent;
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, this.channelId).setContentTitle(title).setContentText(content).setSmallIcon(this.smallIconId).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().setBigContentTitle(title).bigText(content).setSummaryText(content));
            PendingIntent contentIntent = this.createContentIntent();
            if (contentIntent != null) {
                builder.setContentIntent(contentIntent);
            }
            if ((deleteIntent = this.createDeleteIntent()) != null) {
                builder.setDeleteIntent(deleteIntent);
            }
            if (!TextUtils.isEmpty((CharSequence)this.groupId)) {
                builder.setGroup(this.groupId);
            }
            if (this.largeIconId != 0) {
                builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIconId));
            }
            return builder;
        }

        protected boolean isForegroundService() {
            return true;
        }

        protected abstract PendingIntent createContentIntent();

        protected PendingIntent createDeleteIntent() {
            return null;
        }
    }
}

