/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.media.MediaData;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.Time;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class IAudioSampler {
    private final String TAG = this.getClass().getSimpleName();
    public static final int AUDIO_SOURCE_UAC = 100;
    private final int MAX_POOL_SIZE = 200;
    private final int MAX_QUEUE_SIZE = 200;
    private final LinkedBlockingQueue<MediaData> mPool = new LinkedBlockingQueue(200);
    private final LinkedBlockingQueue<MediaData> mAudioQueue = new LinkedBlockingQueue(200);
    private CallbackThread mCallbackThread;
    private final Object mCallbackSync = new Object();
    private final Set<SoundSamplerCallback> mCallbacks = new CopyOnWriteArraySet<SoundSamplerCallback>();
    protected volatile boolean mIsCapturing;
    protected int mDefaultBufferSize = 1024;
    private int mBufferNum = 0;
    private long prevInputPTSUs = -1L;

    @SuppressLint(value={"NewApi"})
    public static AudioRecord createAudioRecord(int source, int sampling_rate, int channels, int format, int buffer_size) {
        int[] AUDIO_SOURCES = new int[]{0, 5, 1, 0, 7, 6};
        switch (source) {
            case 1: {
                AUDIO_SOURCES[0] = 1;
                break;
            }
            case 2: {
                AUDIO_SOURCES[0] = 5;
                break;
            }
            case 3: {
                AUDIO_SOURCES[0] = 7;
                break;
            }
            default: {
                AUDIO_SOURCES[0] = 1;
            }
        }
        AudioRecord audioRecord = null;
        for (int src : AUDIO_SOURCES) {
            try {
                audioRecord = BuildCheck.isAndroid6() ? new AudioRecord.Builder().setAudioSource(src).setAudioFormat(new AudioFormat.Builder().setEncoding(format).setSampleRate(sampling_rate).setChannelMask(channels == 1 ? 16 : 12).build()).setBufferSizeInBytes(buffer_size).build() : new AudioRecord(src, sampling_rate, channels == 1 ? 16 : 12, format, buffer_size);
                if (audioRecord.getState() != 1) {
                    audioRecord.release();
                    audioRecord = null;
                }
            }
            catch (Exception e) {
                audioRecord = null;
            }
            if (audioRecord != null) break;
        }
        return audioRecord;
    }

    public void release() {
        if (this.isStarted()) {
            this.stop();
        }
        this.mCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.mCallbackSync;
        synchronized (object) {
            if (this.mCallbackThread == null) {
                this.mIsCapturing = true;
                this.mCallbackThread = new CallbackThread();
                this.mCallbackThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object object = this.mCallbackSync;
        synchronized (object) {
            boolean capturing = this.mIsCapturing;
            this.mIsCapturing = false;
            this.mCallbackThread = null;
            if (capturing) {
                try {
                    this.mCallbackSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void addCallback(SoundSamplerCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
    }

    public void removeCallback(SoundSamplerCallback callback) {
        if (callback != null) {
            while (this.mCallbacks.remove(callback)) {
            }
        }
    }

    public boolean isStarted() {
        return this.mIsCapturing;
    }

    public abstract int getAudioSource();

    public abstract int getChannels();

    public abstract int getSamplingFrequency();

    public abstract int getBitResolution();

    public int getBufferSize() {
        return this.mDefaultBufferSize;
    }

    private void callOnData(@NonNull MediaData data) {
        ByteBuffer buf = data.mBuffer;
        int size = data.size;
        long pts = data.presentationTimeUs;
        for (SoundSamplerCallback callback : this.mCallbacks) {
            try {
                buf.clear();
                buf.position(size);
                buf.flip();
                callback.onData(buf, size, pts);
            }
            catch (Exception e) {
                this.mCallbacks.remove(callback);
                Log.w((String)this.TAG, (String)"callOnData:", (Throwable)e);
            }
        }
    }

    protected void callOnError(Exception e) {
        for (SoundSamplerCallback callback : this.mCallbacks) {
            try {
                callback.onError(e);
            }
            catch (Exception e1) {
                this.mCallbacks.remove(callback);
                Log.w((String)this.TAG, (String)"callOnError:", (Throwable)e1);
            }
        }
    }

    protected void init_pool(int default_buffer_size) {
        this.mDefaultBufferSize = default_buffer_size;
        this.mAudioQueue.clear();
        this.mPool.clear();
        for (int i = 0; i < 8; ++i) {
            this.mPool.add(new MediaData(default_buffer_size));
        }
    }

    protected MediaData obtain() {
        MediaData result = null;
        if (!this.mPool.isEmpty()) {
            result = this.mPool.poll();
        } else if (this.mBufferNum < 200) {
            result = new MediaData(this.mDefaultBufferSize);
            ++this.mBufferNum;
        }
        if (result != null) {
            result.size = 0;
        }
        return result;
    }

    protected void recycle(@NonNull MediaData data) {
        if (!this.mPool.offer(data)) {
            --this.mBufferNum;
        }
    }

    protected boolean addMediaData(@NonNull MediaData data) {
        return this.mAudioQueue.offer(data);
    }

    protected MediaData pollMediaData(long timeout_msec) throws InterruptedException {
        return this.mAudioQueue.poll(timeout_msec, TimeUnit.MILLISECONDS);
    }

    @SuppressLint(value={"NewApi"})
    protected long getInputPTSUs() {
        long result = Time.nanoTime() / 1000L;
        if (result <= this.prevInputPTSUs) {
            result = this.prevInputPTSUs + 9643L;
        }
        this.prevInputPTSUs = result;
        return result;
    }

    private final class CallbackThread
    extends Thread {
        public CallbackThread() {
            super("AudioSampler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Process.setThreadPriority((int)-16);
            while (IAudioSampler.this.mIsCapturing) {
                MediaData data;
                try {
                    data = IAudioSampler.this.pollMediaData(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (data == null) continue;
                IAudioSampler.this.callOnData(data);
                IAudioSampler.this.recycle(data);
            }
            Object object = IAudioSampler.this.mCallbackSync;
            synchronized (object) {
                IAudioSampler.this.mCallbackSync.notifyAll();
            }
        }
    }

    public static interface SoundSamplerCallback {
        public void onData(ByteBuffer var1, int var2, long var3);

        public void onError(Exception var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioSource {
    }
}

