/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.db;

import android.annotation.SuppressLint;
import android.database.Cursor;
import android.util.Log;

public final class CursorHelper {
    private static final String TAG = CursorHelper.class.getSimpleName();

    public static String getString(Cursor cursor, String columnName, String defaultValue) {
        String result = defaultValue;
        try {
            result = cursor.getString(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static CharSequence getCharSequence(Cursor cursor, String columnName, CharSequence defaultValue) {
        CharSequence result = defaultValue;
        try {
            result = cursor.getString(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getString(Cursor cursor, String columnName, CharSequence defaultValue) {
        CharSequence result = CursorHelper.getCharSequence(cursor, columnName, defaultValue);
        return result != null ? result.toString() : null;
    }

    public static int getInt(Cursor cursor, String columnName, int defaultValue) {
        int result = defaultValue;
        try {
            result = cursor.getInt(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static short getShort(Cursor cursor, String columnName, short defaultValue) {
        short result = defaultValue;
        try {
            result = cursor.getShort(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static long getLong(Cursor cursor, String columnName, long defaultValue) {
        long result = defaultValue;
        try {
            result = cursor.getLong(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static float getFloat(Cursor cursor, String columnName, float defaultValue) {
        float result = defaultValue;
        try {
            result = cursor.getFloat(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static double getDouble(Cursor cursor, String columnName, double defaultValue) {
        double result = defaultValue;
        try {
            result = cursor.getDouble(cursor.getColumnIndexOrThrow(columnName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findPositionFromId(Cursor cursor, long requestID) {
        int position;
        block5: {
            position = -1;
            if (cursor != null) {
                int savedPosition = cursor.getPosition();
                try {
                    if (!cursor.moveToFirst()) break block5;
                    do {
                        long rowId;
                        if ((rowId = CursorHelper.getLong(cursor, "_id", 0L)) != requestID) continue;
                        position = cursor.getPosition();
                        break;
                    } while (cursor.moveToNext());
                }
                finally {
                    cursor.moveToPosition(savedPosition);
                }
            }
        }
        return position;
    }

    @SuppressLint(value={"NewApi"})
    public static void dumpCursor(Cursor cursor) {
        if (cursor.moveToFirst()) {
            int row = 0;
            StringBuilder sb = new StringBuilder();
            int n = cursor.getColumnCount();
            String[] columnNames = cursor.getColumnNames();
            do {
                sb.setLength(0);
                sb.append("row=").append(row).append(", ");
                block8: for (int i = 0; i < n; ++i) {
                    switch (cursor.getType(i)) {
                        case 2: {
                            sb.append(columnNames[i]).append("=").append(cursor.getDouble(i));
                            break;
                        }
                        case 1: {
                            sb.append(columnNames[i]).append("=").append(cursor.getLong(i));
                            break;
                        }
                        case 3: {
                            sb.append(columnNames[i]).append("=").append(cursor.getString(i));
                            break;
                        }
                        case 4: {
                            sb.append(columnNames[i]).append("=").append("BLOB");
                            break;
                        }
                        case 0: {
                            sb.append(columnNames[i]).append("=").append("NULL");
                            continue block8;
                        }
                        default: {
                            sb.append(columnNames[i]).append("=").append("UNKNOWN");
                            continue block8;
                        }
                    }
                    sb.append(", ");
                }
                Log.v((String)"CursorHelper#dumpCursor:", (String)sb.toString());
                ++row;
            } while (cursor.moveToNext());
        }
    }
}

