/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.SeekBar;
import android.widget.TextView;
import com.serenegiant.common.R;
import java.util.Locale;

public class FrameSelectorView
extends LinearLayout {
    private static final String TAG = FrameSelectorView.class.getSimpleName();
    private static final SparseIntArray sBUTTONS = new SparseIntArray();
    private static final int[] COLOR_BTN_IDS;
    private final int[] mColors = new int[]{-65536, -23296, -256, -16744448, -16776961, -1, -5131855, -16777216};
    private FrameSelectorViewCallback mCallback;
    private final ImageButton[] mFrameButtons = new ImageButton[7];
    private RadioGroup mScaleTypeRadioGroup;
    private TextView mLineWidthTv;
    private SeekBar mSeekBar;
    private final View.OnClickListener mOnFrameClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (FrameSelectorView.this.mCallback != null) {
                try {
                    FrameSelectorView.this.mCallback.onFrameSelected(FrameSelectorView.this, sBUTTONS.get(view.getId()));
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    };
    private final View.OnClickListener mOnColorClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (FrameSelectorView.this.mCallback != null) {
                try {
                    int ix = sBUTTONS.get(view.getId());
                    if (ix >= 0 && ix < 8) {
                        FrameSelectorView.this.mCallback.onColorSelected(FrameSelectorView.this, ix, FrameSelectorView.this.mColors[ix]);
                    } else {
                        FrameSelectorView.this.mCallback.onColorSelected(FrameSelectorView.this, -1, 0);
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    };
    private final RadioGroup.OnCheckedChangeListener mOnCheckedChangeListener = new RadioGroup.OnCheckedChangeListener(){

        public void onCheckedChanged(RadioGroup group, int checkedId) {
            int scale_type = 0;
            if (checkedId == R.id.scale_type_inch_radiobutton) {
                scale_type = 1;
            } else if (checkedId == R.id.scale_type_mm_radiobutton) {
                scale_type = 2;
            }
            if (FrameSelectorView.this.mCallback != null) {
                try {
                    FrameSelectorView.this.mCallback.onScaleSelected(FrameSelectorView.this, scale_type);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    };
    private final SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (FrameSelectorView.this.mLineWidthTv != null) {
                FrameSelectorView.this.mLineWidthTv.setText((CharSequence)String.format(Locale.US, "%4.1fpx", Float.valueOf((float)progress / 10.0f)));
            }
            if (fromUser && FrameSelectorView.this.mCallback != null) {
                try {
                    FrameSelectorView.this.mCallback.onLineWidthChanged(FrameSelectorView.this, (float)seekBar.getProgress() / 10.0f);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            if (FrameSelectorView.this.mCallback != null) {
                try {
                    FrameSelectorView.this.mCallback.onLineWidthSelected(FrameSelectorView.this, (float)seekBar.getProgress() / 10.0f);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    };

    public FrameSelectorView(Context context) {
        this(context, null, 0);
    }

    public FrameSelectorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FrameSelectorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        try {
            View rootView = inflater.inflate(R.layout.view_frame_selector, (ViewGroup)this, true);
            this.initView(rootView);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCallback(FrameSelectorViewCallback callback) {
        this.mCallback = callback;
    }

    public FrameSelectorViewCallback getCallback() {
        return this.mCallback;
    }

    public void setFrameType(int frame_type) {
        if (frame_type > 0 && frame_type < 8) {
            for (int i = 0; i < 7; ++i) {
                this.mFrameButtons[i].setSelected(false);
            }
            this.mFrameButtons[frame_type - 1].setSelected(true);
        }
    }

    public void setScaleType(int scale_type) {
        if (this.mScaleTypeRadioGroup != null) {
            switch (scale_type) {
                case 1: {
                    this.mScaleTypeRadioGroup.check(R.id.scale_type_inch_radiobutton);
                    break;
                }
                case 2: {
                    this.mScaleTypeRadioGroup.check(R.id.scale_type_mm_radiobutton);
                    break;
                }
                default: {
                    this.mScaleTypeRadioGroup.check(R.id.scale_type_non_radiobutton);
                }
            }
        }
    }

    public void setLineWidth(float width) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setProgress((int)(width * 10.0f));
        }
    }

    public void setColors(int[] colors) {
        if (colors != null && colors.length >= 8) {
            System.arraycopy(this.mColors, 0, colors, 0, 8);
            this.updateColors(colors);
        }
    }

    public int[] getColors() {
        return this.mColors;
    }

    public void addColor(int color) {
        int ix = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.mColors[i] != color) continue;
            ix = i;
            break;
        }
        System.arraycopy(this.mColors, ix, this.mColors, ix + 1, 7);
        this.mColors[7] = color;
        this.updateColors(this.mColors);
    }

    private void updateColors(final int[] colors) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (colors != null && colors.length >= 8) {
                    for (int i = 0; i < 8; ++i) {
                        int id2 = COLOR_BTN_IDS[i];
                        ImageButton button = (ImageButton)FrameSelectorView.this.findViewById(id2);
                        if (button == null) continue;
                        button.setBackgroundColor(colors[i]);
                    }
                }
            }
        });
    }

    private void initView(View rootView) {
        this.mFrameButtons[0] = (ImageButton)rootView.findViewById(R.id.frame_frame_button);
        this.mFrameButtons[0].setOnClickListener(this.mOnFrameClickListener);
        this.mFrameButtons[1] = (ImageButton)rootView.findViewById(R.id.frame_cross_button);
        this.mFrameButtons[1].setOnClickListener(this.mOnFrameClickListener);
        this.mFrameButtons[2] = (ImageButton)rootView.findViewById(R.id.frame_cross_quarter_button);
        this.mFrameButtons[2].setOnClickListener(this.mOnFrameClickListener);
        this.mFrameButtons[3] = (ImageButton)rootView.findViewById(R.id.frame_circle_button);
        this.mFrameButtons[3].setOnClickListener(this.mOnFrameClickListener);
        this.mFrameButtons[4] = (ImageButton)rootView.findViewById(R.id.frame_circle2_button);
        this.mFrameButtons[4].setOnClickListener(this.mOnFrameClickListener);
        this.mFrameButtons[5] = (ImageButton)rootView.findViewById(R.id.frame_cross_circle_button);
        this.mFrameButtons[5].setOnClickListener(this.mOnFrameClickListener);
        this.mFrameButtons[6] = (ImageButton)rootView.findViewById(R.id.frame_cross_circle2_button);
        this.mFrameButtons[6].setOnClickListener(this.mOnFrameClickListener);
        ImageButton button = (ImageButton)rootView.findViewById(R.id.color1_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color2_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color3_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color4_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color5_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color6_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color7_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color8_button);
        button.setOnClickListener(this.mOnColorClickListener);
        button = (ImageButton)rootView.findViewById(R.id.color_select_button);
        button.setOnClickListener(this.mOnColorClickListener);
        this.mScaleTypeRadioGroup = (RadioGroup)rootView.findViewById(R.id.scale_type_radiogroup);
        this.mScaleTypeRadioGroup.setOnCheckedChangeListener(this.mOnCheckedChangeListener);
        this.mLineWidthTv = (TextView)rootView.findViewById(R.id.line_width_textview);
        this.mSeekBar = (SeekBar)rootView.findViewById(R.id.line_width_seekbar);
        this.mSeekBar.setOnSeekBarChangeListener(this.mOnSeekBarChangeListener);
    }

    static {
        sBUTTONS.put(R.id.color1_button, 0);
        sBUTTONS.put(R.id.color2_button, 1);
        sBUTTONS.put(R.id.color3_button, 2);
        sBUTTONS.put(R.id.color4_button, 3);
        sBUTTONS.put(R.id.color5_button, 4);
        sBUTTONS.put(R.id.color6_button, 5);
        sBUTTONS.put(R.id.color7_button, 6);
        sBUTTONS.put(R.id.color8_button, 7);
        sBUTTONS.put(R.id.color_select_button, -1);
        sBUTTONS.put(R.id.frame_frame_button, 1);
        sBUTTONS.put(R.id.frame_cross_button, 2);
        sBUTTONS.put(R.id.frame_cross_quarter_button, 3);
        sBUTTONS.put(R.id.frame_circle_button, 4);
        sBUTTONS.put(R.id.frame_circle2_button, 6);
        sBUTTONS.put(R.id.frame_cross_circle_button, 5);
        sBUTTONS.put(R.id.frame_cross_circle2_button, 7);
        COLOR_BTN_IDS = new int[]{R.id.color1_button, R.id.color2_button, R.id.color3_button, R.id.color4_button, R.id.color5_button, R.id.color6_button, R.id.color7_button, R.id.color8_button};
    }

    public static interface FrameSelectorViewCallback {
        public void onFrameSelected(FrameSelectorView var1, int var2);

        public void onColorSelected(FrameSelectorView var1, int var2, int var3);

        public void onScaleSelected(FrameSelectorView var1, int var2);

        public void onLineWidthChanged(FrameSelectorView var1, float var2);

        public void onLineWidthSelected(FrameSelectorView var1, float var2);
    }
}

