/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import com.serenegiant.glutils.ShaderConst;
import com.serenegiant.mediaeffect.MediaEffectGLESBase;
import com.serenegiant.mediaeffect.MediaEffectKernel3x3Drawer;

public class MediaEffectKernel
extends MediaEffectGLESBase {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEffectKernel";

    public MediaEffectKernel() {
        super(new MediaEffectKernel3x3Drawer(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_2D));
    }

    public MediaEffectKernel(float[] kernel) {
        this();
        this.setParameter(kernel, 0.0f);
    }

    public MediaEffectKernel(float[] kernel, float color_adjust) {
        this();
        this.setParameter(kernel, color_adjust);
    }

    @Override
    public MediaEffectKernel resize(int width, int height) {
        super.resize(width, height);
        this.setTexSize(width, height);
        return this;
    }

    public void setKernel(float[] values, float colorAdj) {
        ((MediaEffectKernel3x3Drawer)this.mDrawer).setKernel(values, colorAdj);
    }

    public void setColorAdjust(float adjust) {
        ((MediaEffectKernel3x3Drawer)this.mDrawer).setColorAdjust(adjust);
    }

    public void setTexSize(int width, int height) {
        this.mDrawer.setTexSize(width, height);
    }

    public MediaEffectKernel setParameter(float[] kernel, float color_adjust) {
        this.setKernel(kernel, color_adjust);
        return this;
    }
}

