/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.media.IMediaCodecCallback;
import com.serenegiant.media.ISurfaceEncoder;
import com.serenegiant.media.MediaCodecHelper;
import com.serenegiant.media.MediaEncoder;
import com.serenegiant.media.MediaMovieRecorder;
import java.io.IOException;
import java.util.Locale;

@TargetApi(value=18)
public class MediaVideoEncoder
extends MediaEncoder
implements ISurfaceEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEncoder";
    private static final String MIME_TYPE = "video/avc";
    private static final int FRAME_RATE = 25;
    private static final float BPP = 0.25f;
    private Surface mSurface;
    private int mVideoWidth = 1280;
    private int mVideoHeight = 720;

    public MediaVideoEncoder(MediaMovieRecorder muxer, IMediaCodecCallback listener) {
        this(1280, 720, muxer, listener);
    }

    public MediaVideoEncoder(int width, int height, MediaMovieRecorder muxer, IMediaCodecCallback listener) {
        super(false, muxer, listener);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    @Override
    public void prepare() throws IOException {
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mMuxerStarted = false;
        MediaCodecInfo videoCodecInfo = MediaCodecHelper.selectVideoEncoder(MIME_TYPE);
        if (videoCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mVideoWidth, (int)this.mVideoHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.calcBitRate());
        format.setInteger("frame-rate", 25);
        format.setInteger("i-frame-interval", 10);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(format, null, null, 1);
        this.mSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
        this.mIsPrepared = true;
        this.callOnPrepared();
    }

    @Override
    public void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        super.release();
    }

    @Override
    public void setVideoSize(int width, int height) throws IllegalArgumentException, IllegalStateException {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException(String.format(Locale.US, "size(%d,%d)", width, height));
        }
        if (this.isRunning()) {
            throw new IllegalStateException("already start capturing");
        }
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    @Override
    public Surface getInputSurface() throws IllegalStateException {
        if (this.mSurface == null) {
            throw new IllegalStateException("not prepared yet");
        }
        return this.mSurface;
    }

    @Override
    public int getWidth() {
        return this.mVideoWidth;
    }

    @Override
    public int getHeight() {
        return this.mVideoHeight;
    }

    private int calcBitRate() {
        int bitrate = (int)(6.25f * (float)this.mVideoWidth * (float)this.mVideoHeight);
        Log.i((String)TAG, (String)String.format("bitrate=%5.2f[Mbps]", Float.valueOf((float)bitrate / 1024.0f / 1024.0f)));
        return bitrate;
    }
}

