/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Process;
import android.util.Log;
import com.serenegiant.media.IAudioEncoder;
import com.serenegiant.media.IMediaCodecCallback;
import com.serenegiant.media.MediaCodecHelper;
import com.serenegiant.media.MediaEncoder;
import com.serenegiant.media.MediaMovieRecorder;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaAudioEncoder
extends MediaEncoder
implements IAudioEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaAudioEncoder";
    private static final String MIME_TYPE = "audio/mp4a-latm";
    private static final int SAMPLE_RATE = 44100;
    private static final int BIT_RATE = 64000;
    public static final int SAMPLES_PER_FRAME = 1024;
    public static final int FRAMES_PER_BUFFER = 25;
    private AudioThread mAudioThread = null;
    private static final int[] AUDIO_SOURCES = new int[]{5, 1, 0, 7, 6};

    public MediaAudioEncoder(MediaMovieRecorder muxer, IMediaCodecCallback listener) {
        super(true, muxer, listener);
    }

    @Override
    public void prepare() throws IOException {
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mMuxerStarted = false;
        MediaCodecInfo audioCodecInfo = MediaCodecHelper.selectAudioEncoder(MIME_TYPE);
        if (audioCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for audio/mp4a-latm");
            return;
        }
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)MIME_TYPE, (int)44100, (int)1);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", 16);
        audioFormat.setInteger("bitrate", 64000);
        audioFormat.setInteger("channel-count", 1);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        this.mIsPrepared = true;
        this.callOnPrepared();
    }

    @Override
    public void start() {
        super.start();
        if (this.mAudioThread == null) {
            this.mAudioThread = new AudioThread();
            this.mAudioThread.start();
        }
    }

    @Override
    public void release() {
        this.mAudioThread = null;
        super.release();
    }

    private class AudioThread
    extends Thread {
        private AudioThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                Process.setThreadPriority((int)-19);
                try {
                    int min_buffer_size = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
                    int buffer_size = 25600;
                    if (buffer_size < min_buffer_size) {
                        buffer_size = (min_buffer_size / 1024 + 1) * 1024 * 2;
                    }
                    AudioRecord audioRecord = null;
                    for (int source : AUDIO_SOURCES) {
                        try {
                            audioRecord = new AudioRecord(source, 44100, 16, 2, buffer_size);
                            if (audioRecord != null && audioRecord.getState() != 1) {
                                audioRecord.release();
                                audioRecord = null;
                            }
                        }
                        catch (Exception e) {
                            audioRecord = null;
                        }
                        if (audioRecord != null) break;
                    }
                    if (audioRecord == null) break block14;
                    try {
                        if (!MediaAudioEncoder.this.mIsCapturing || audioRecord.getState() != 1) break block14;
                        ByteBuffer buf = ByteBuffer.allocateDirect(1024);
                        audioRecord.startRecording();
                        try {
                            while (MediaAudioEncoder.this.mIsCapturing && !MediaAudioEncoder.this.mRequestStop && !MediaAudioEncoder.this.mIsEOS) {
                                buf.clear();
                                int readBytes = audioRecord.read(buf, 1024);
                                if (readBytes <= 0) continue;
                                buf.position(readBytes);
                                buf.flip();
                                MediaAudioEncoder.this.encode(buf, readBytes, MediaAudioEncoder.this.getPTSUs());
                                MediaAudioEncoder.this.frameAvailableSoon();
                            }
                            MediaAudioEncoder.this.frameAvailableSoon();
                        }
                        finally {
                            audioRecord.stop();
                        }
                    }
                    finally {
                        audioRecord.release();
                    }
                }
                catch (Exception e) {
                    Log.e((String)MediaAudioEncoder.TAG, (String)"AudioThread#run", (Throwable)e);
                }
            }
        }
    }
}

