/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils.es1;

import android.opengl.GLES10;
import android.opengl.Matrix;
import com.serenegiant.glutils.IDrawer2D;
import com.serenegiant.glutils.ITexture;
import com.serenegiant.glutils.TextureOffscreen;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GLDrawer2D
implements IDrawer2D {
    private static final float[] VERTICES = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] TEXCOORD = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    private static final int FLOAT_SZ = 4;
    private static final int VERTEX_NUM = 4;
    private static final int VERTEX_SZ = 8;
    private final float[] mMvpMatrix = new float[16];
    private final FloatBuffer pVertex;
    private final FloatBuffer pTexCoord;
    private final int mTexTarget;

    public GLDrawer2D(boolean isOES) {
        this.mTexTarget = isOES ? 36197 : 3553;
        this.pVertex = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.pVertex.put(VERTICES);
        this.pVertex.flip();
        this.pTexCoord = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.pTexCoord.put(TEXCOORD);
        this.pTexCoord.flip();
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
    }

    @Override
    public void release() {
    }

    @Override
    public float[] getMvpMatrix() {
        return this.mMvpMatrix;
    }

    @Override
    public IDrawer2D setMvpMatrix(float[] matrix, int offset) {
        System.arraycopy(matrix, offset, this.mMvpMatrix, 0, 16);
        return this;
    }

    @Override
    public void getMvpMatrix(float[] matrix, int offset) {
        System.arraycopy(this.mMvpMatrix, 0, matrix, offset, 16);
    }

    @Override
    public void draw(int texId, float[] tex_matrix, int offset) {
        GLES10.glEnableClientState((int)32884);
        this.pVertex.position(0);
        GLES10.glVertexPointer((int)2, (int)5126, (int)8, (Buffer)this.pVertex);
        GLES10.glEnableClientState((int)32888);
        this.pTexCoord.position(0);
        GLES10.glTexCoordPointer((int)4, (int)5126, (int)8, (Buffer)this.pTexCoord);
        GLES10.glActiveTexture((int)33984);
        GLES10.glBindTexture((int)this.mTexTarget, (int)texId);
        GLES10.glDrawArrays((int)5, (int)0, (int)4);
        GLES10.glBindTexture((int)this.mTexTarget, (int)0);
        GLES10.glDisableClientState((int)32888);
        GLES10.glDisableClientState((int)32884);
    }

    @Override
    public void draw(ITexture texture) {
        this.draw(texture.getTexture(), texture.getTexMatrix(), 0);
    }

    @Override
    public void draw(TextureOffscreen offscreen) {
        this.draw(offscreen.getTexture(), offscreen.getTexMatrix(), 0);
    }
}

