/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(api=16)
public final class MediaInfo {
    private static final List<MediaCodecInfo> sCodecList = new ArrayList<MediaCodecInfo>();
    private static final HashMap<String, HashMap<MediaCodecInfo, MediaCodecInfo.CodecCapabilities>> sCapabilities = new HashMap();

    public static JSONObject get() throws JSONException {
        JSONObject result = new JSONObject();
        try {
            result.put("VIDEO", (Object)MediaInfo.getVideo());
        }
        catch (Exception e) {
            result.put("VIDEO", (Object)e.getMessage());
        }
        try {
            result.put("AUDIO", (Object)MediaInfo.getAudio());
        }
        catch (Exception e) {
            result.put("AUDIO", (Object)e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JSONObject getVideo() throws JSONException {
        JSONObject result = new JSONObject();
        int numCodecs = MediaInfo.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaInfo.getCodecInfoAt(i);
            JSONObject codec = new JSONObject();
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            boolean isvideo = false;
            for (int j = 0; j < n; ++j) {
                int k;
                int m;
                MediaCodecInfo.CodecCapabilities capabilities;
                if (!types[j].startsWith("video/")) continue;
                isvideo = true;
                codec.put(Integer.toString(j), (Object)types[j]);
                Thread.currentThread().setPriority(10);
                try {
                    capabilities = MediaInfo.getCodecCapabilities(codecInfo, types[j]);
                }
                finally {
                    Thread.currentThread().setPriority(5);
                }
                try {
                    int[] colorFormats = capabilities.colorFormats;
                    int n2 = m = colorFormats != null ? colorFormats.length : 0;
                    if (m > 0) {
                        JSONObject caps = new JSONObject();
                        for (k = 0; k < m; ++k) {
                            caps.put(String.format(Locale.US, "COLOR_FORMAT(%d)", k), (Object)MediaInfo.getColorFormatName(colorFormats[k]));
                        }
                        codec.put("COLOR_FORMATS", (Object)caps);
                    }
                }
                catch (Exception e) {
                    codec.put("COLOR_FORMATS", (Object)e.getMessage());
                }
                try {
                    MediaCodecInfo.CodecProfileLevel[] profileLevel = capabilities.profileLevels;
                    int n3 = m = profileLevel != null ? profileLevel.length : 0;
                    if (m <= 0) continue;
                    JSONObject profiles = new JSONObject();
                    for (k = 0; k < m; ++k) {
                        profiles.put(Integer.toString(k), (Object)MediaInfo.getProfileLevelString(types[j], profileLevel[k]));
                    }
                    codec.put("PROFILES", (Object)profiles);
                    continue;
                }
                catch (Exception e) {
                    codec.put("PROFILES", (Object)e.getMessage());
                }
            }
            if (!isvideo) continue;
            result.put(codecInfo.getName(), (Object)codec);
        }
        return result;
    }

    private static final JSONObject getAudio() throws JSONException {
        JSONObject result = new JSONObject();
        int numCodecs = MediaInfo.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaInfo.getCodecInfoAt(i);
            JSONObject codec = new JSONObject();
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            boolean isaudio = false;
            for (int j = 0; j < n; ++j) {
                if (!types[j].startsWith("audio/")) continue;
                isaudio = true;
                codec.put(Integer.toString(j), (Object)types[j]);
            }
            if (!isaudio) continue;
            result.put(codecInfo.getName(), (Object)codec);
        }
        return result;
    }

    public static final String getColorFormatName(int colorFormat) {
        switch (colorFormat) {
            case 3: {
                return "COLOR_Format12bitRGB444";
            }
            case 5: {
                return "COLOR_Format16bitARGB1555";
            }
            case 4: {
                return "COLOR_Format16bitARGB4444";
            }
            case 7: {
                return "COLOR_Format16bitBGR565";
            }
            case 6: {
                return "COLOR_Format16bitRGB565";
            }
            case 41: {
                return "COLOR_Format18BitBGR666";
            }
            case 9: {
                return "COLOR_Format18bitARGB1665";
            }
            case 8: {
                return "COLOR_Format18bitRGB666";
            }
            case 10: {
                return "COLOR_Format19bitARGB1666";
            }
            case 43: {
                return "COLOR_Format24BitABGR6666";
            }
            case 42: {
                return "COLOR_Format24BitARGB6666";
            }
            case 13: {
                return "COLOR_Format24bitARGB1887";
            }
            case 12: {
                return "COLOR_Format24bitBGR888";
            }
            case 11: {
                return "COLOR_Format24bitRGB888";
            }
            case 14: {
                return "COLOR_Format25bitARGB1888";
            }
            case 16: {
                return "COLOR_Format32bitARGB8888";
            }
            case 15: {
                return "COLOR_Format32bitBGRA8888";
            }
            case 2: {
                return "COLOR_Format8bitRGB332";
            }
            case 27: {
                return "COLOR_FormatCbYCrY";
            }
            case 28: {
                return "COLOR_FormatCrYCbY";
            }
            case 36: {
                return "COLOR_FormatL16";
            }
            case 33: {
                return "COLOR_FormatL2";
            }
            case 37: {
                return "COLOR_FormatL24";
            }
            case 38: {
                return "COLOR_FormatL32";
            }
            case 34: {
                return "COLOR_FormatL4";
            }
            case 35: {
                return "COLOR_FormatL8";
            }
            case 1: {
                return "COLOR_FormatMonochrome";
            }
            case 31: {
                return "COLOR_FormatRawBayer10bit";
            }
            case 30: {
                return "COLOR_FormatRawBayer8bit";
            }
            case 32: {
                return "COLOR_FormatRawBayer8bitcompressed";
            }
            case 2130708361: {
                return "COLOR_FormatSurface_COLOR_FormatAndroidOpaque";
            }
            case 25: {
                return "COLOR_FormatYCbYCr";
            }
            case 26: {
                return "COLOR_FormatYCrYCb";
            }
            case 18: {
                return "COLOR_FormatYUV411PackedPlanar";
            }
            case 17: {
                return "COLOR_FormatYUV411Planar";
            }
            case 20: {
                return "COLOR_FormatYUV420PackedPlanar";
            }
            case 39: {
                return "COLOR_FormatYUV420PackedSemiPlanar";
            }
            case 19: {
                return "COLOR_FormatYUV420Planar";
            }
            case 21: {
                return "COLOR_FormatYUV420SemiPlanar";
            }
            case 23: {
                return "COLOR_FormatYUV422PackedPlanar";
            }
            case 40: {
                return "COLOR_FormatYUV422PackedSemiPlanar";
            }
            case 22: {
                return "COLOR_FormatYUV422Planar";
            }
            case 24: {
                return "COLOR_FormatYUV422SemiPlanar";
            }
            case 29: {
                return "COLOR_FormatYUV444Interleaved";
            }
            case 2141391872: {
                return "COLOR_QCOM_FormatYUV420SemiPlanar";
            }
            case 2130706688: {
                return "COLOR_TI_FormatYUV420PackedSemiPlanar";
            }
            case 0x6F000000: {
                return "OMX_COLOR_FormatKhronosExtensions";
            }
            case 2135033992: {
                return "COLOR_FormatYUV420Flexible";
            }
            case 2141391875: {
                return "OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar64x32Tile2m8ka";
            }
            case 2143289346: {
                return "OMX_SEC_COLOR_FormatNV12Tiled";
            }
            case 2141391876: {
                return "OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar32m";
            }
        }
        return String.format(Locale.getDefault(), "COLOR_Format_Unknown(%d)", colorFormat);
    }

    public static String getProfileLevelString(String mimeType, MediaCodecInfo.CodecProfileLevel profileLevel) {
        String result;
        if (!TextUtils.isEmpty((CharSequence)mimeType)) {
            if (mimeType.equalsIgnoreCase("video/avc")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "AVCProfileBaseline";
                        break;
                    }
                    case 2: {
                        result = "AVCProfileMain";
                        break;
                    }
                    case 4: {
                        result = "AVCProfileExtended";
                        break;
                    }
                    case 8: {
                        result = "AVCProfileHigh";
                        break;
                    }
                    case 16: {
                        result = "AVCProfileHigh10";
                        break;
                    }
                    case 32: {
                        result = "AVCProfileHigh422";
                        break;
                    }
                    case 64: {
                        result = "AVCProfileHigh444";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".AVCLevel1";
                        break;
                    }
                    case 2: {
                        result = result + ".AVCLevel1b";
                        break;
                    }
                    case 4: {
                        result = result + ".AVCLevel11";
                        break;
                    }
                    case 8: {
                        result = result + ".AVCLevel12";
                        break;
                    }
                    case 16: {
                        result = result + ".AVCLevel13";
                        break;
                    }
                    case 32: {
                        result = result + ".AVCLevel2";
                        break;
                    }
                    case 64: {
                        result = result + ".AVCLevel21";
                        break;
                    }
                    case 128: {
                        result = result + ".AVCLevel22";
                        break;
                    }
                    case 256: {
                        result = result + ".AVCLevel3";
                        break;
                    }
                    case 512: {
                        result = result + ".AVCLevel31";
                        break;
                    }
                    case 1024: {
                        result = result + ".AVCLevel32";
                        break;
                    }
                    case 2048: {
                        result = result + ".AVCLevel4";
                        break;
                    }
                    case 4096: {
                        result = result + ".AVCLevel41";
                        break;
                    }
                    case 8192: {
                        result = result + ".AVCLevel42";
                        break;
                    }
                    case 16384: {
                        result = result + ".AVCLevel5";
                        break;
                    }
                    case 32768: {
                        result = result + ".AVCLevel51";
                        break;
                    }
                    default: {
                        result = result + ".unknown level " + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/h263")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "H263ProfileBaseline";
                        break;
                    }
                    case 2: {
                        result = "H263ProfileH320Coding";
                        break;
                    }
                    case 4: {
                        result = "H263ProfileBackwardCompatible";
                        break;
                    }
                    case 8: {
                        result = "H263ProfileISWV2";
                        break;
                    }
                    case 16: {
                        result = "H263ProfileISWV3";
                        break;
                    }
                    case 32: {
                        result = "H263ProfileHighCompression";
                        break;
                    }
                    case 64: {
                        result = "H263ProfileInternet";
                        break;
                    }
                    case 128: {
                        result = "H263ProfileInterlace";
                        break;
                    }
                    case 256: {
                        result = "H263ProfileHighLatency";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".H263Level10";
                        break;
                    }
                    case 2: {
                        result = result + ".H263Level20";
                        break;
                    }
                    case 4: {
                        result = result + ".H263Level30";
                        break;
                    }
                    case 8: {
                        result = result + ".H263Level40";
                        break;
                    }
                    case 16: {
                        result = result + ".H263Level45";
                        break;
                    }
                    case 32: {
                        result = result + ".H263Level50";
                        break;
                    }
                    case 64: {
                        result = result + ".H263Level60";
                        break;
                    }
                    case 128: {
                        result = result + ".H263Level70";
                        break;
                    }
                    default: {
                        result = result + ".unknown level " + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/mpeg4")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "MPEG4ProfileSimple";
                        break;
                    }
                    case 2: {
                        result = "MPEG4ProfileSimpleScalable";
                        break;
                    }
                    case 4: {
                        result = "MPEG4ProfileCore";
                        break;
                    }
                    case 8: {
                        result = "MPEG4ProfileMain";
                        break;
                    }
                    case 16: {
                        result = "MPEG4ProfileNbit";
                        break;
                    }
                    case 32: {
                        result = "MPEG4ProfileScalableTexture";
                        break;
                    }
                    case 64: {
                        result = "MPEG4ProfileSimpleFace";
                        break;
                    }
                    case 128: {
                        result = "MPEG4ProfileSimpleFBA";
                        break;
                    }
                    case 256: {
                        result = "MPEG4ProfileBasicAnimated";
                        break;
                    }
                    case 512: {
                        result = "MPEG4ProfileHybrid";
                        break;
                    }
                    case 1024: {
                        result = "MPEG4ProfileAdvancedRealTime";
                        break;
                    }
                    case 2048: {
                        result = "MPEG4ProfileCoreScalable";
                        break;
                    }
                    case 4096: {
                        result = "MPEG4ProfileAdvancedCoding";
                        break;
                    }
                    case 8192: {
                        result = "MPEG4ProfileAdvancedCore";
                        break;
                    }
                    case 16384: {
                        result = "MPEG4ProfileAdvancedScalable";
                        break;
                    }
                    case 32768: {
                        result = "MPEG4ProfileAdvancedSimple";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".MPEG4Level0";
                        break;
                    }
                    case 2: {
                        result = result + ".MPEG4Level0b";
                        break;
                    }
                    case 4: {
                        result = result + ".MPEG4Level1";
                        break;
                    }
                    case 8: {
                        result = result + ".MPEG4Level2";
                        break;
                    }
                    case 16: {
                        result = result + ".MPEG4Level3";
                        break;
                    }
                    case 32: {
                        result = result + ".MPEG4Level4";
                        break;
                    }
                    case 64: {
                        result = result + ".MPEG4Level4a";
                        break;
                    }
                    case 128: {
                        result = result + ".MPEG4Level5";
                        break;
                    }
                    default: {
                        result = result + ".unknown level " + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("ausio/aac")) {
                switch (profileLevel.level) {
                    case 1: {
                        result = "AACObjectMain";
                        break;
                    }
                    case 2: {
                        result = "AACObjectLC";
                        break;
                    }
                    case 3: {
                        result = "AACObjectSSR";
                        break;
                    }
                    case 4: {
                        result = "AACObjectLTP";
                        break;
                    }
                    case 5: {
                        result = "AACObjectHE";
                        break;
                    }
                    case 6: {
                        result = "AACObjectScalable";
                        break;
                    }
                    case 17: {
                        result = "AACObjectERLC";
                        break;
                    }
                    case 23: {
                        result = "AACObjectLD";
                        break;
                    }
                    case 29: {
                        result = "AACObjectHE_PS";
                        break;
                    }
                    case 39: {
                        result = "AACObjectELD";
                        break;
                    }
                    default: {
                        result = "profile:unknown " + profileLevel.profile;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/vp8")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "VP8ProfileMain";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".VP8Level_Version0";
                        break;
                    }
                    case 2: {
                        result = result + ".VP8Level_Version1";
                        break;
                    }
                    case 4: {
                        result = result + ".VP8Level_Version2";
                        break;
                    }
                    case 8: {
                        result = result + ".VP8Level_Version3";
                        break;
                    }
                    default: {
                        result = result + ".unknown level" + profileLevel.level;
                        break;
                    }
                }
            } else {
                result = "unknown profile " + profileLevel.profile;
            }
        } else {
            result = "mime type is null";
        }
        return result;
    }

    private static final void updateCodecs() {
        if (sCodecList.size() == 0) {
            int n = MediaCodecList.getCodecCount();
            for (int i = 0; i < n; ++i) {
                sCodecList.add(MediaCodecList.getCodecInfoAt((int)i));
            }
        }
    }

    public static final int getCodecCount() {
        MediaInfo.updateCodecs();
        return sCodecList.size();
    }

    public static final List<MediaCodecInfo> getCodecs() {
        MediaInfo.updateCodecs();
        return sCodecList;
    }

    public static final MediaCodecInfo getCodecInfoAt(int ix) {
        MediaInfo.updateCodecs();
        return sCodecList.get(ix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaCodecInfo.CodecCapabilities getCodecCapabilities(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities capabilities;
        HashMap<Object, Object> caps = sCapabilities.get(mimeType);
        if (caps == null) {
            caps = new HashMap();
            sCapabilities.put(mimeType, caps);
        }
        if ((capabilities = caps.get(codecInfo)) == null) {
            Thread.currentThread().setPriority(10);
            try {
                capabilities = codecInfo.getCapabilitiesForType(mimeType);
                caps.put(codecInfo, capabilities);
            }
            finally {
                Thread.currentThread().setPriority(5);
            }
        }
        return capabilities;
    }
}

