/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.util.List;

public class GyroHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = GyroHelper.class.getSimpleName();
    private static final int[] SENSOR_TYPES = new int[]{2, 9, 1, 4};
    private final Object mSync = new Object();
    private final WeakReference<Context> mWeakContext;
    private SensorManager mSensorManager;
    private boolean mRegistered;
    private int mRotation;
    private final Object mSensorSync = new Object();
    private final float[] mMagnetValues = new float[3];
    private final float[] mGravityValues = new float[3];
    private final float[] mAzimuthValues = new float[3];
    private final float[] mAccelValues = new float[3];
    private final float[] mGyroValues = new float[3];
    private final SensorEventListener mSensorEventListener = new SensorEventListener(){
        private final float[] outR = new float[16];
        private final float[] outR2 = new float[16];
        private static final float TO_DEGREE = 57.29578f;
        private final float[] mRotateMatrix = new float[16];
        private final float[] mInclinationMatrix = new float[16];

        private void highPassFilter(float[] values, float[] new_values, float alpha) {
            values[0] = alpha * values[0] + (1.0f - alpha) * new_values[0];
            values[1] = alpha * values[1] + (1.0f - alpha) * new_values[1];
            values[2] = alpha * values[2] + (1.0f - alpha) * new_values[2];
        }

        private void getOrientation(float[] rotateMatrix, float[] result) {
            switch (GyroHelper.this.mRotation) {
                case 0: {
                    SensorManager.getOrientation((float[])rotateMatrix, (float[])result);
                    return;
                }
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])rotateMatrix, (int)2, (int)129, (float[])this.outR);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])rotateMatrix, (int)2, (int)129, (float[])this.outR2);
                    SensorManager.remapCoordinateSystem((float[])this.outR2, (int)2, (int)129, (float[])this.outR);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])this.outR, (int)130, (int)129, (float[])this.outR);
                }
            }
            SensorManager.getOrientation((float[])this.outR, (float[])result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSensorChanged(SensorEvent event) {
            float[] values = event.values;
            int type = event.sensor.getType();
            switch (type) {
                case 2: {
                    Object object = GyroHelper.this.mSensorSync;
                    synchronized (object) {
                        this.highPassFilter(GyroHelper.this.mMagnetValues, values, 0.8f);
                        System.arraycopy(values, 0, GyroHelper.this.mMagnetValues, 0, 3);
                        SensorManager.getRotationMatrix((float[])this.mRotateMatrix, (float[])this.mInclinationMatrix, (float[])GyroHelper.this.mGravityValues, (float[])GyroHelper.this.mMagnetValues);
                        this.getOrientation(this.mRotateMatrix, GyroHelper.this.mAzimuthValues);
                        float[] fArray = GyroHelper.this.mAzimuthValues;
                        fArray[0] = fArray[0] * 57.29578f;
                        float[] fArray2 = GyroHelper.this.mAzimuthValues;
                        fArray2[1] = fArray2[1] * 57.29578f;
                        float[] fArray3 = GyroHelper.this.mAzimuthValues;
                        fArray3[2] = fArray3[2] * 57.29578f;
                        break;
                    }
                }
                case 9: {
                    Object object = GyroHelper.this.mSensorSync;
                    synchronized (object) {
                        System.arraycopy(values, 0, GyroHelper.this.mGravityValues, 0, 3);
                        break;
                    }
                }
                case 1: {
                    Object object = GyroHelper.this.mSensorSync;
                    synchronized (object) {
                        System.arraycopy(values, 0, GyroHelper.this.mAccelValues, 0, 3);
                        System.arraycopy(values, 0, GyroHelper.this.mGravityValues, 0, 3);
                        break;
                    }
                }
                case 4: {
                    Object object = GyroHelper.this.mSensorSync;
                    synchronized (object) {
                        System.arraycopy(values, 0, GyroHelper.this.mGyroValues, 0, 3);
                        break;
                    }
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GyroHelper(@NonNull Context context) {
        this.mWeakContext = new WeakReference<Context>(context);
        Object object = this.mSync;
        synchronized (object) {
            this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            this.mSensorManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            Context context = (Context)this.mWeakContext.get();
            if (this.mSensorManager == null || context == null) {
                throw new IllegalStateException("already released");
            }
            for (int i = 0; i < 3; ++i) {
                this.mAzimuthValues[i] = 0.0f;
                this.mGravityValues[i] = 0.0f;
                this.mMagnetValues[i] = 0.0f;
                this.mGyroValues[i] = 0.0f;
                this.mAccelValues[i] = 0.0f;
            }
            boolean hasGravity = false;
            this.mRegistered = true;
            for (int sensor_type : SENSOR_TYPES) {
                List sensors = this.mSensorManager.getSensorList(sensor_type);
                if (sensors != null && sensors.size() > 0) {
                    if (sensor_type == 9) {
                        Log.i((String)TAG, (String)"hasGravity");
                        hasGravity = true;
                    }
                    if (hasGravity && sensor_type == 1) continue;
                    this.mSensorManager.registerListener(this.mSensorEventListener, (Sensor)sensors.get(0), 1);
                    continue;
                }
                Log.i((String)TAG, (String)String.format("no sensor for sensor type %d", sensor_type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRegistered && this.mSensorManager != null) {
                try {
                    this.mSensorManager.unregisterListener(this.mSensorEventListener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mRegistered = false;
        }
    }

    public void setScreenRotation(int rotation) {
        this.mRotation = rotation;
    }

    public float getAzimuth() {
        return this.mAzimuthValues[0];
    }

    public float getPan() {
        return this.mAzimuthValues[1];
    }

    public float getTilt() {
        return this.mAzimuthValues[2];
    }
}

