/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import android.graphics.Bitmap;
import com.serenegiant.glutils.TextureOffscreen;
import com.serenegiant.mediaeffect.IEffect;
import com.serenegiant.mediaeffect.ISource;
import com.serenegiant.mediaeffect.MediaSource;

public class MediaImageSource
extends MediaSource {
    private TextureOffscreen mImageOffscreen;
    private boolean isReset;

    public MediaImageSource(Bitmap src) {
        super(src.getWidth(), src.getHeight());
        this.mImageOffscreen = new TextureOffscreen(this.mWidth, this.mHeight, false);
        this.setSource(src);
    }

    public ISource setSource(Bitmap bitmap) {
        this.mImageOffscreen.loadBitmap(bitmap);
        this.reset();
        return this;
    }

    @Override
    public ISource reset() {
        super.reset();
        this.isReset = true;
        this.mSrcTexIds[0] = this.mImageOffscreen.getTexture();
        return this;
    }

    @Override
    public ISource apply(IEffect effect) {
        if (this.mSourceScreen != null) {
            if (this.isReset) {
                this.isReset = false;
                this.needSwap = true;
            } else {
                if (this.needSwap) {
                    TextureOffscreen temp = this.mSourceScreen;
                    this.mSourceScreen = this.mOutputScreen;
                    this.mOutputScreen = temp;
                    this.mSrcTexIds[0] = this.mSourceScreen.getTexture();
                }
                this.needSwap = !this.needSwap;
            }
            effect.apply(this.mSrcTexIds, this.mOutputScreen.getTexWidth(), this.mOutputScreen.getTexHeight(), this.mOutputScreen.getTexture());
        }
        return this;
    }
}

