/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Process;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.media.Encoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.ISurfaceEncoder;
import com.serenegiant.media.TimeoutException;
import com.serenegiant.utils.BufferHelper;
import com.serenegiant.utils.Time;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public abstract class AbstractEncoder
implements Encoder {
    private static final String TAG = AbstractEncoder.class.getSimpleName();
    public static final int TIMEOUT_USEC = 10000;
    private volatile int mRequestDrain;
    protected volatile boolean mIsCapturing;
    protected volatile boolean mRequestStop;
    protected volatile boolean mRecorderStarted;
    protected volatile boolean mIsEOS;
    protected int mTrackIndex;
    protected MediaCodec mMediaCodec;
    private MediaCodec.BufferInfo mBufferInfo;
    private IRecorder mRecorder;
    protected final Object mSync = new Object();
    private final EncoderListener mListener;
    protected final String MIME_TYPE;
    private final Runnable mDrainTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Process.setThreadPriority((int)-4);
            Object object2 = AbstractEncoder.this.mSync;
            synchronized (object2) {
                AbstractEncoder.this.mRequestStop = false;
                AbstractEncoder.this.mRequestDrain = 0;
                AbstractEncoder.this.mSync.notify();
            }
            boolean localRequestStop = false;
            while (!AbstractEncoder.this.mIsCapturing && !localRequestStop) {
                object = AbstractEncoder.this.mSync;
                synchronized (object) {
                    try {
                        AbstractEncoder.this.mSync.wait(10L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    localRequestStop = AbstractEncoder.this.mRequestStop;
                    AbstractEncoder.this.mRequestDrain = 0;
                }
            }
            while (true) {
                boolean localRequestDrain;
                object = AbstractEncoder.this.mSync;
                synchronized (object) {
                    localRequestStop = AbstractEncoder.this.mRequestStop;
                    boolean bl = localRequestDrain = AbstractEncoder.this.mRequestDrain > 0;
                    if (localRequestDrain) {
                        AbstractEncoder.this.mRequestDrain--;
                    }
                }
                if (localRequestStop) {
                    try {
                        AbstractEncoder.this.drain();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        AbstractEncoder.this.signalEndOfInputStream();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        AbstractEncoder.this.drain();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    AbstractEncoder.this.release();
                    break;
                }
                if (localRequestDrain) {
                    try {
                        AbstractEncoder.this.drain();
                    }
                    catch (Exception e) {
                        if (!AbstractEncoder.this.mRequestStop) {
                            AbstractEncoder.this.callOnError(e);
                        }
                        AbstractEncoder.this.mRequestStop = true;
                    }
                    continue;
                }
                object = AbstractEncoder.this.mSync;
                synchronized (object) {
                    try {
                        AbstractEncoder.this.mSync.wait(30L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            object = AbstractEncoder.this.mSync;
            synchronized (object) {
                AbstractEncoder.this.mRequestStop = true;
                AbstractEncoder.this.mIsCapturing = false;
                AbstractEncoder.this.mSync.notifyAll();
            }
        }
    };
    private long prevOutputPTSUs = -1L;
    private long prevInputPTSUs = -1L;

    public AbstractEncoder(String mime_type, IRecorder recorder, EncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("EncodeListener is null");
        }
        if (recorder == null) {
            throw new NullPointerException("IMuxer is null");
        }
        this.MIME_TYPE = mime_type;
        this.mRecorder = recorder;
        this.mListener = listener;
        recorder.addEncoder(this);
        this.mBufferInfo = new MediaCodec.BufferInfo();
    }

    public IRecorder getRecorder() {
        return this.mRecorder;
    }

    @Override
    public String getOutputPath() {
        return this.mRecorder != null ? this.mRecorder.getOutputPath() : null;
    }

    public int getCaptureFormat() {
        return -1;
    }

    protected void finalize() throws Throwable {
        this.mRecorder = null;
        this.release();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prepare() throws Exception {
        boolean mayFail = this.internalPrepare();
        Surface surface = this instanceof ISurfaceEncoder ? ((ISurfaceEncoder)((Object)this)).getInputSurface() : null;
        try {
            this.mListener.onStartEncode(this, surface, this.getCaptureFormat(), mayFail);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        Object object = this.mSync;
        synchronized (object) {
            new Thread(this.mDrainTask, this.getClass().getSimpleName()).start();
            try {
                this.mSync.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected abstract boolean internalPrepare() throws Exception;

    protected void callOnError(Exception e) {
        try {
            this.mListener.onError(e);
        }
        catch (Exception e2) {
            Log.w((String)TAG, (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = true;
            this.mRequestStop = false;
            this.mRequestDrain = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRequestStop) {
                return;
            }
            this.mRequestStop = true;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            ++this.mRequestDrain;
            this.mSync.notifyAll();
        }
    }

    @Override
    public void release() {
        if (this.mIsCapturing) {
            try {
                this.mListener.onStopEncode(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mRecorderStarted) {
            this.mRecorderStarted = false;
            if (this.mRecorder != null) {
                try {
                    this.mRecorder.stop(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            this.mListener.onDestroy(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mBufferInfo = null;
        this.mRecorder = null;
    }

    @Override
    public void signalEndOfInputStream() {
        this.encode(null, 0, this.getInputPTSUs());
    }

    @Override
    public void encode(ByteBuffer buffer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCapturing() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mIsCapturing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            if (this.mMediaCodec == null) {
                return;
            }
        }
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                if (buffer != null && length > 0) {
                    buffer.clear();
                    buffer.position(length);
                    buffer.flip();
                    inputBuffer.put(buffer);
                }
                if (length <= 0) {
                    this.mIsEOS = true;
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, length, presentationTimeUs, 0);
                break;
            }
            if (inputBufferIndex != -1) continue;
            this.frameAvailableSoon();
        }
    }

    private final void drain() {
        ByteBuffer[] encoderOutputBuffers;
        if (this.mMediaCodec == null) {
            return;
        }
        try {
            encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
        }
        catch (IllegalStateException e) {
            return;
        }
        int count = 0;
        IRecorder recorder = this.mRecorder;
        if (recorder == null) {
            return;
        }
        while (this.mIsCapturing) {
            int encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            if (encoderStatus == -1) {
                if (this.mIsEOS || ++count <= 5) continue;
                break;
            }
            if (encoderStatus == -3) {
                encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                if (this.mRecorderStarted) {
                    throw new RuntimeException("format changed twice");
                }
                MediaFormat format = this.mMediaCodec.getOutputFormat();
                if (this.startRecorder(recorder, format)) continue;
                break;
            }
            if (encoderStatus < 0) continue;
            ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
            if (encodedData == null) {
                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
            }
            if ((this.mBufferInfo.flags & 2) != 0) {
                if (!this.mRecorderStarted) {
                    byte[] tmp = new byte[this.mBufferInfo.size];
                    encodedData.position(0);
                    encodedData.get(tmp, this.mBufferInfo.offset, this.mBufferInfo.size);
                    encodedData.position(0);
                    int ix0 = BufferHelper.byteComp(tmp, 0, BufferHelper.ANNEXB_START_MARK, BufferHelper.ANNEXB_START_MARK.length);
                    int ix1 = BufferHelper.byteComp(tmp, ix0 + 2, BufferHelper.ANNEXB_START_MARK, BufferHelper.ANNEXB_START_MARK.length);
                    int ix2 = BufferHelper.byteComp(tmp, ix1 + 2, BufferHelper.ANNEXB_START_MARK, BufferHelper.ANNEXB_START_MARK.length);
                    MediaFormat outFormat = this.createOutputFormat(tmp, this.mBufferInfo.size, ix0, ix1, ix2);
                    if (!this.startRecorder(recorder, outFormat)) break;
                }
                this.mBufferInfo.size = 0;
            }
            if (this.mBufferInfo.size != 0) {
                count = 0;
                if (!this.mRecorderStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                try {
                    this.mBufferInfo.presentationTimeUs = this.getNextOutputPTSUs(this.mBufferInfo.presentationTimeUs);
                    recorder.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                }
                catch (TimeoutException e) {
                    recorder.stopRecording();
                }
                catch (Exception e) {
                    recorder.stopRecording();
                }
            }
            this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
            if ((this.mBufferInfo.flags & 4) == 0) continue;
            this.stopRecorder(recorder);
            break;
        }
    }

    protected abstract MediaFormat createOutputFormat(byte[] var1, int var2, int var3, int var4, int var5);

    protected boolean startRecorder(IRecorder recorder, MediaFormat outFormat) {
        if (recorder.getState() != 3) {
            for (int i = 0; i < 10 && recorder.getState() != 3; ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        if (recorder.getState() == 3) {
            this.mTrackIndex = recorder.addTrack(this, outFormat);
            if (this.mTrackIndex >= 0) {
                this.mRecorderStarted = true;
                if (!recorder.start(this)) {
                    // empty if block
                }
            } else {
                recorder.removeEncoder(this);
            }
        }
        return recorder.isStarted();
    }

    protected void stopRecorder(IRecorder recorder) {
        this.mIsCapturing = false;
        this.mRecorderStarted = false;
    }

    @SuppressLint(value={"NewApi"})
    protected long getInputPTSUs() {
        long result = Time.nanoTime() / 1000L;
        if (result <= this.prevInputPTSUs) {
            result = this.prevInputPTSUs + 9643L;
        }
        this.prevInputPTSUs = result;
        return result;
    }

    protected long getNextOutputPTSUs(long presentationTimeUs) {
        if (presentationTimeUs <= this.prevOutputPTSUs) {
            presentationTimeUs = this.prevOutputPTSUs + 9643L;
        }
        this.prevOutputPTSUs = presentationTimeUs;
        return presentationTimeUs;
    }
}

