/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.math;

import com.serenegiant.math.BaseBounds;
import com.serenegiant.math.Vector;

public class CylinderBounds
extends BaseBounds {
    private static final long serialVersionUID = -2875851852923460432L;
    protected float height;
    protected float outer_r;
    private final Vector w1 = new Vector();
    private final Vector w2 = new Vector();

    public CylinderBounds(float x, float y, float z, float height, float radius) {
        this.position.set(x, y, z);
        this.radius = (float)Math.sqrt(radius * radius + height * height / 4.0f);
        this.outer_r = radius;
        this.height = height / 2.0f;
    }

    public CylinderBounds(Vector center, float height, float radius) {
        this(center.x, center.y, center.z, height, radius);
    }

    protected boolean ptInCylinder(float x, float y, float z, float r) {
        boolean f = false;
        this.w1.set(x, y, z).sub(this.position).rotate(this.angle, -1.0f);
        this.w2.set(this.w1);
        this.w2.y = 0.0f;
        if (this.w2.distSquared(this.position.x, 0.0f, this.position.z) < r * r) {
            float x1 = this.position.x - r;
            float x2 = this.position.x + r;
            float y1 = this.position.y - this.height;
            float y2 = this.position.y + this.height;
            f = this.w1.x >= x1 && this.w1.x <= x2 && this.w1.y >= y1 && this.w1.y <= y2;
        }
        return f;
    }

    @Override
    public boolean ptInBounds(float x, float y, float z) {
        boolean f = this.ptInBoundsSphere(x, y, z, this.radius);
        if (f) {
            f = this.ptInCylinder(x, y, z, this.outer_r);
        }
        return f;
    }
}

