/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import com.serenegiant.glutils.GLHelper;
import com.serenegiant.glutils.ShaderConst;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Locale;

public class MediaEffectDrawer {
    protected boolean mEnabled = true;
    private static final float[] VERTICES = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] TEXCOORD = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    private static final int FLOAT_SZ = 4;
    private static final int VERTEX_NUM = 4;
    private static final int VERTEX_SZ = 8;
    protected final Object mSync = new Object();
    protected final int mTexTarget;
    protected final int muMVPMatrixLoc;
    protected final int muTexMatrixLoc;
    protected final int[] muTexLoc;
    protected final float[] mMvpMatrix = new float[16];
    protected int hProgram;

    public static MediaEffectDrawer newInstance() {
        return new MediaEffectSingleDrawer(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_2D);
    }

    public static MediaEffectDrawer newInstance(int numTex) {
        if (numTex <= 1) {
            return new MediaEffectSingleDrawer(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_2D);
        }
        return new MediaEffectDrawer(numTex, false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_2D);
    }

    public static MediaEffectDrawer newInstance(String fss) {
        return new MediaEffectSingleDrawer(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public static MediaEffectDrawer newInstance(int numTex, String fss) {
        if (numTex <= 1) {
            return new MediaEffectSingleDrawer(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
        }
        return new MediaEffectDrawer(numTex, false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public static MediaEffectDrawer newInstance(boolean isOES, String fss) {
        return new MediaEffectSingleDrawer(isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public static MediaEffectDrawer newInstance(int numTex, boolean isOES, String fss) {
        if (numTex <= 1) {
            return new MediaEffectSingleDrawer(isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
        }
        return new MediaEffectDrawer(numTex, isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public static MediaEffectDrawer newInstance(boolean isOES, String vss, String fss) {
        return new MediaEffectSingleDrawer(isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public static MediaEffectDrawer newInstance(int numTex, boolean isOES, String vss, String fss) {
        if (numTex <= 1) {
            return new MediaEffectSingleDrawer(isOES, vss, fss);
        }
        return new MediaEffectDrawer(numTex, isOES, vss, fss);
    }

    protected MediaEffectDrawer() {
        this(1, false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_2D);
    }

    protected MediaEffectDrawer(int numTex) {
        this(numTex, false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_2D);
    }

    protected MediaEffectDrawer(String fss) {
        this(1, false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    protected MediaEffectDrawer(int numTex, String fss) {
        this(numTex, false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    protected MediaEffectDrawer(boolean isOES, String fss) {
        this(1, isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    protected MediaEffectDrawer(int numTex, boolean isOES, String fss) {
        this(numTex, isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    protected MediaEffectDrawer(boolean isOES, String vss, String fss) {
        this(1, isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    protected MediaEffectDrawer(int numTex, boolean isOES, String vss, String fss) {
        this.mTexTarget = isOES ? 36197 : 3553;
        FloatBuffer pVertex = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        pVertex.put(VERTICES);
        pVertex.flip();
        FloatBuffer pTexCoord = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        pTexCoord.put(TEXCOORD);
        pTexCoord.flip();
        this.muTexLoc = new int[numTex > 0 ? numTex : 1];
        this.hProgram = GLHelper.loadShader(vss, fss);
        GLES20.glUseProgram((int)this.hProgram);
        int maPositionLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aPosition");
        int maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uTexMatrix");
        this.muTexLoc[0] = GLES20.glGetUniformLocation((int)this.hProgram, (String)"sTexture");
        for (int i = 1; i < numTex; ++i) {
            this.muTexLoc[i] = GLES20.glGetUniformLocation((int)this.hProgram, (String)String.format(Locale.US, "sTexture%d", i + 1));
        }
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
        if (this.muMVPMatrixLoc >= 0) {
            GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        }
        if (this.muTexMatrixLoc >= 0) {
            GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        }
        GLES20.glVertexAttribPointer((int)maPositionLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)pVertex);
        GLES20.glEnableVertexAttribArray((int)maPositionLoc);
        GLES20.glVertexAttribPointer((int)maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)pTexCoord);
        GLES20.glEnableVertexAttribArray((int)maTextureCoordLoc);
    }

    public void release() {
        GLES20.glUseProgram((int)0);
        if (this.hProgram >= 0) {
            GLES20.glDeleteProgram((int)this.hProgram);
        }
        this.hProgram = -1;
    }

    protected int getProgram() {
        return this.hProgram;
    }

    public float[] getMvpMatrix() {
        return this.mMvpMatrix;
    }

    public void setTexSize(int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMvpMatrix(float[] matrix, int offset) {
        Object object = this.mSync;
        synchronized (object) {
            System.arraycopy(matrix, offset, this.mMvpMatrix, 0, this.mMvpMatrix.length);
        }
    }

    public void getMvpMatrix(float[] matrix, int offset) {
        System.arraycopy(this.mMvpMatrix, 0, matrix, offset, this.mMvpMatrix.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(@NonNull int[] tex_ids, float[] tex_matrix, int offset) {
        Object object = this.mSync;
        synchronized (object) {
            GLES20.glUseProgram((int)this.hProgram);
            this.preDraw(tex_ids, tex_matrix, offset);
            this.draw(tex_ids, tex_matrix, offset);
            this.postDraw();
        }
    }

    protected void preDraw(@NonNull int[] tex_ids, float[] tex_matrix, int offset) {
        if (this.muTexMatrixLoc >= 0 && tex_matrix != null) {
            GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])tex_matrix, (int)offset);
        }
        if (this.muMVPMatrixLoc >= 0) {
            GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        }
        this.bindTexture(tex_ids);
    }

    protected void bindTexture(@NonNull int[] tex_ids) {
        int n = tex_ids.length < this.muTexLoc.length ? tex_ids.length : this.muTexLoc.length;
        for (int i = 0; i < n; ++i) {
            if (tex_ids[i] == -1) continue;
            GLES20.glActiveTexture((int)ShaderConst.TEX_NUMBERS[i]);
            GLES20.glBindTexture((int)this.mTexTarget, (int)tex_ids[i]);
            GLES20.glUniform1i((int)this.muTexLoc[i], (int)i);
        }
    }

    protected void draw(@NonNull int[] tex_ids, float[] tex_matrix, int offset) {
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    protected void postDraw() {
        this.unbindTexture();
        GLES20.glUseProgram((int)0);
    }

    protected void unbindTexture() {
        for (int i = 0; i < this.muTexLoc.length; ++i) {
            GLES20.glActiveTexture((int)ShaderConst.TEX_NUMBERS[i]);
            GLES20.glBindTexture((int)this.mTexTarget, (int)0);
        }
    }

    protected static class MediaEffectSingleDrawer
    extends MediaEffectDrawer {
        protected MediaEffectSingleDrawer(boolean isOES, String vss, String fss) {
            super(1, isOES, vss, fss);
        }

        @Override
        protected void bindTexture(@NonNull int[] tex_ids) {
            GLES20.glActiveTexture((int)ShaderConst.TEX_NUMBERS[0]);
            if (tex_ids[0] != -1) {
                GLES20.glBindTexture((int)this.mTexTarget, (int)tex_ids[0]);
                GLES20.glUniform1i((int)this.muTexLoc[0], (int)0);
            }
        }

        @Override
        protected void unbindTexture() {
            GLES20.glActiveTexture((int)ShaderConst.TEX_NUMBERS[0]);
            GLES20.glBindTexture((int)this.mTexTarget, (int)0);
        }
    }
}

